/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.stats;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.stats.TrackedPluginsEnum;
import com.comalatech.confluence.workflow.stats.WorkflowStatisticsManager;
import com.comalatech.workflow.model.Workflow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="workflowStatsGatherJob")
public class StatsGatheringJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(StatsGatheringJob.class);
    private final TransactionTemplate transactionTemplate;
    private final WorkflowStatisticsManager workflowStatisticsManager;
    private final SpaceManager spaceManager;
    private final WorkflowService workflowService;
    private final PluginAccessor pluginAccessor;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    public static final String STAT_SPACE_USAGE = "workflowStatsSpaceUsage";
    public static final String STAT_LICENSE_TYPE = "workflowStatsLicenseType";
    public static final String STAT_LICENSE_SIZE = "workflowStatsLicenseSize";
    public static final String STAT_WORKFLOWS_VERSION = "workflowStatsWorkflowsVersion";
    public static final String STAT_CONFLUENCE_VERSION = "workflowStatsConfluenceVersion";
    public static final String STAT_TRACKED_PLUGINS = "workflowStatsInstalledPlugins";
    public static final String STAT_DARK_FEATURES = "workflowDarkFeaturesEnabled";
    public static final String USAGE_NONE = "none";
    public static final String USAGE_LOW = "low";
    public static final String USAGE_MODERATE = "moderate";
    public static final String USAGE_MEDIUM = "medium";
    public static final String USAGE_HIGH = "high";
    public static final String USAGE_DEDICATED = "dedicated";

    public StatsGatheringJob(@ComponentImport TransactionTemplate transactionTemplate, WorkflowStatisticsManager workflowStatisticsManager, @ComponentImport SpaceManager spaceManager, WorkflowService workflowService, @ComponentImport PluginAccessor pluginAccessor, WorkflowConfigurationManager workflowConfigurationManager) {
        this.transactionTemplate = transactionTemplate;
        this.workflowStatisticsManager = workflowStatisticsManager;
        this.spaceManager = spaceManager;
        this.workflowService = workflowService;
        this.pluginAccessor = pluginAccessor;
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("StatsGatheringJob starting");
        }
        try {
            PluginContainerManager.autowireComponent(this);
            if (this.workflowStatisticsManager.isStatsEnabled()) {
                return (JobRunnerResponse)this.transactionTemplate.execute(() -> {
                    if (request.isCancellationRequested()) {
                        return JobRunnerResponse.aborted((String)"Job cancelled.");
                    }
                    Map<String, String> statFields = this.getStatFields();
                    this.workflowStatisticsManager.pushSystemStats(statFields);
                    return JobRunnerResponse.success((String)"Job finished successfully.");
                });
            }
        }
        catch (Error | Exception e) {
            log.error("", e);
            return JobRunnerResponse.failed((String)"Job failed.");
        }
        return JobRunnerResponse.success((String)"Job finished successfully.");
    }

    protected Map<String, String> getStatFields() {
        if (log.isInfoEnabled()) {
            log.info("Generating Workflow System Statistics");
        }
        HashMap<String, String> statFields = new HashMap<String, String>();
        License license = LicenseManager.getInstance().getLicense("CONF");
        if (license != null) {
            int licensedUsers = license.getUsers();
            String licenseType = license.getLicenseType().getNewLicenseTypeName();
            statFields.put(STAT_LICENSE_TYPE, licenseType);
            statFields.put(STAT_LICENSE_SIZE, "" + licensedUsers);
        }
        List allSpaces = this.spaceManager.getAllSpaces();
        int spaceWorkflowCount = 0;
        block3: for (Space space : allSpaces) {
            if (space == null) continue;
            List<Workflow> workflows = this.workflowService.getWorkflows(space.getKey());
            for (Workflow workflow : workflows) {
                if (!workflow.isActive()) continue;
                ++spaceWorkflowCount;
                continue block3;
            }
        }
        double totalSpaces = this.spaceManager.getAllSpaces().size();
        double usagePercent = (double)spaceWorkflowCount / totalSpaces;
        String usageDescription = usagePercent >= 0.8 ? USAGE_DEDICATED : (usagePercent >= 0.5 ? USAGE_HIGH : (usagePercent >= 0.3 ? USAGE_MEDIUM : (usagePercent >= 0.1 ? USAGE_MODERATE : (usagePercent > 0.0 ? USAGE_LOW : USAGE_NONE))));
        statFields.put(STAT_SPACE_USAGE, usageDescription);
        ArrayList<String> installedPluginsList = new ArrayList<String>();
        for (TrackedPluginsEnum plugin : TrackedPluginsEnum.values()) {
            JSONObject installedPluginJSON = new JSONObject();
            try {
                installedPluginJSON.put("statParam", plugin.getStatParam());
                installedPluginJSON.put("isInstalled", this.checkIfPluginInstalled(plugin.getKey()));
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            catch (Error e) {
                log.error("", (Throwable)e);
            }
            installedPluginsList.add(installedPluginJSON.toString());
        }
        statFields.put(STAT_TRACKED_PLUGINS, ((Object)installedPluginsList).toString());
        String workflowsVersion = this.workflowConfigurationManager.getConfiguration().getPluginVersion();
        String confluenceVersion = GeneralUtil.getVersionNumber();
        statFields.put(STAT_WORKFLOWS_VERSION, workflowsVersion);
        statFields.put(STAT_CONFLUENCE_VERSION, confluenceVersion);
        statFields.put(STAT_DARK_FEATURES, this.getDarkFeatureStatList());
        if (log.isDebugEnabled()) {
            log.debug("Workflow stats: " + statFields);
            log.debug("Workflow System Statistics Generation Complete");
        }
        return statFields;
    }

    protected String getDarkFeatureStatList() {
        ArrayList<String> darkFeaturesList = new ArrayList<String>();
        JSONObject installedPluginJSON = new JSONObject();
        darkFeaturesList.add(installedPluginJSON.toString());
        return ((Object)darkFeaturesList).toString();
    }

    public String checkIfPluginInstalled(String pluginKey) {
        String pluginIsInstalled = "Not Installed";
        if (this.pluginAccessor.getPlugin(pluginKey) != null) {
            pluginIsInstalled = "Installed";
        }
        return pluginIsInstalled;
    }
}

