/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model.mappers;

import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StateSelection;
import com.comalatech.confluence.states.model.StateSubmission;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.restv2.model.RestCondition;
import com.comalatech.confluence.workflow.restv2.model.RestSelect;
import com.comalatech.confluence.workflow.restv2.model.RestState;
import com.comalatech.confluence.workflow.restv2.model.RestTransition;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mapper;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mappers;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class StateMapper
implements Mapper<State, RestState> {
    @Override
    public RestState toRest(State state) {
        RestState restState = new RestState();
        restState.name = state.getName();
        restState.description = state.getDescription();
        restState.transitions = this.toRestTransitions(state);
        restState.finalState = state.isFinalState() ? Boolean.valueOf(true) : null;
        restState.assignable = state.isAssignable() ? Boolean.valueOf(true) : null;
        restState.taskable = state.isTaskable() ? Boolean.valueOf(true) : null;
        restState.dueDate = state.getDueDate();
        restState.changeDueDate = state.isChangeDueDate() ? Boolean.valueOf(true) : null;
        restState.hideFromPath = state.isHideFromPath() ? Boolean.valueOf(true) : null;
        restState.hideSelection = state.isHideSelectionProperty() ? Boolean.valueOf(true) : null;
        restState.versionsCompleted = state.isVersionsCompleted() ? Boolean.valueOf(true) : null;
        restState.colour = state.getColour();
        List<String> list = restState.requiredParams = StringUtils.isNotEmpty((CharSequence)state.getRequiredParams()) ? Arrays.asList(StringUtils.split((String)state.getRequiredParams(), (String)",")) : null;
        if (state.getApprovals() != null && !state.getApprovals().isEmpty()) {
            restState.approvals = state.getApprovals().stream().map(Mappers.approvalMapper::toRest).collect(Collectors.toList());
        }
        if (state.getTasks() != null && !state.getTasks().isEmpty()) {
            restState.tasks = state.getTasks().stream().map(Mappers.taskMapper::toRest).collect(Collectors.toList());
        }
        if (state.getReadAck() != null) {
            restState.readAck = Mappers.readAckMapper.toRest(state.getReadAck());
        }
        return restState;
    }

    @Override
    public State fromRest(RestState restState) {
        State state = new State(restState.name, BooleanUtils.isTrue((Boolean)restState.finalState));
        state.setDescription(restState.description);
        state.setAssignable(BooleanUtils.isTrue((Boolean)restState.assignable));
        state.setTaskable(BooleanUtils.isTrue((Boolean)restState.taskable));
        state.setChangeDueDate(BooleanUtils.isTrue((Boolean)restState.changeDueDate));
        this.parseDueDateFromRest(restState.dueDate, state);
        state.setHideFromPath(BooleanUtils.isTrue((Boolean)restState.hideFromPath));
        state.setHideSelection(BooleanUtils.isTrue((Boolean)restState.hideSelection));
        state.setVersionsCompleted(BooleanUtils.isTrue((Boolean)restState.versionsCompleted));
        state.setColour(restState.colour);
        state.setRequiredParams(StringUtils.join(restState.requiredParams, (String)","));
        if (restState.transitions != null) {
            if (restState.transitions.stream().anyMatch(restTransition -> StringUtils.isNotBlank((CharSequence)restTransition.approved))) {
                state.setApprovedStateName(restState.transitions.stream().filter((Predicate<RestTransition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fromRest$1(com.comalatech.confluence.workflow.restv2.model.RestTransition ), (Lcom/comalatech/confluence/workflow/restv2/model/RestTransition;)Z)()).findFirst().get().approved);
            }
            if (restState.transitions.stream().anyMatch(restTransition -> StringUtils.isNotBlank((CharSequence)restTransition.rejected))) {
                state.setRejectedStateName(restState.transitions.stream().filter((Predicate<RestTransition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fromRest$3(com.comalatech.confluence.workflow.restv2.model.RestTransition ), (Lcom/comalatech/confluence/workflow/restv2/model/RestTransition;)Z)()).findFirst().get().rejected);
            }
            if (restState.transitions.stream().anyMatch(restTransition -> StringUtils.isNotBlank((CharSequence)restTransition.updated))) {
                state.setUpdatedStateName(restState.transitions.stream().filter((Predicate<RestTransition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fromRest$5(com.comalatech.confluence.workflow.restv2.model.RestTransition ), (Lcom/comalatech/confluence/workflow/restv2/model/RestTransition;)Z)()).findFirst().get().updated);
            }
            if (restState.transitions.stream().anyMatch(restTransition -> StringUtils.isNotBlank((CharSequence)restTransition.expired))) {
                state.setExpiredStateName(restState.transitions.stream().filter((Predicate<RestTransition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fromRest$7(com.comalatech.confluence.workflow.restv2.model.RestTransition ), (Lcom/comalatech/confluence/workflow/restv2/model/RestTransition;)Z)()).findFirst().get().expired);
            }
            if (restState.transitions.stream().anyMatch(restTransition -> StringUtils.isNotBlank((CharSequence)restTransition.completed))) {
                state.setCompletedStateName(restState.transitions.stream().filter((Predicate<RestTransition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fromRest$9(com.comalatech.confluence.workflow.restv2.model.RestTransition ), (Lcom/comalatech/confluence/workflow/restv2/model/RestTransition;)Z)()).findFirst().get().completed);
            }
            ArrayList<StateSelection> stateSelections = new ArrayList<StateSelection>();
            List select = restState.transitions.stream().filter(restTransition -> null != restTransition.select).collect(Collectors.toList());
            for (RestTransition transition : select) {
                String[] allowedStateNames = transition.select.stateNames.toArray(new String[0]);
                List conditions = null;
                if (transition.select.selectConditions != null) {
                    conditions = transition.select.selectConditions.stream().map(Mappers.conditionMapper::fromRest).filter(Objects::nonNull).collect(Collectors.toList());
                }
                stateSelections.add(new StateSelection(conditions, allowedStateNames));
            }
            restState.transitions.stream().filter(restTransition -> StringUtils.isNotBlank((CharSequence)restTransition.submit)).findFirst().ifPresent(restTransition -> stateSelections.add(new StateSubmission(restTransition.submit)));
            state.setStateSelections(stateSelections);
        }
        if (restState.approvals != null) {
            state.setApprovals(restState.approvals.stream().map(Mappers.approvalMapper::fromRest).collect(Collectors.toList()));
        }
        if (restState.tasks != null) {
            state.setTasks(restState.tasks.stream().map(Mappers.taskMapper::fromRest).collect(Collectors.toList()));
        }
        if (restState.readAck != null) {
            state.setReadAck(Mappers.readAckMapper.fromRest(restState.readAck));
        }
        return state;
    }

    private List<RestTransition> toRestTransitions(State state) {
        RestTransition transition;
        ArrayList<RestTransition> restTransitionList = new ArrayList<RestTransition>();
        if (state.getApprovedStateName() != null) {
            transition = new RestTransition();
            transition.approved = state.getApprovedStateName();
            restTransitionList.add(transition);
        }
        if (state.getRejectedStateName() != null) {
            transition = new RestTransition();
            transition.rejected = state.getRejectedStateName();
            restTransitionList.add(transition);
        }
        if (state.getUpdatedStateName() != null) {
            transition = new RestTransition();
            transition.updated = state.getUpdatedStateName();
            restTransitionList.add(transition);
        }
        if (state.getExpiredStateName() != null) {
            transition = new RestTransition();
            transition.expired = state.getExpiredStateName();
            restTransitionList.add(transition);
        }
        if (state.getSubmitState() != null) {
            transition = new RestTransition();
            transition.submit = state.getSubmitState().getName();
            restTransitionList.add(transition);
        }
        if (state.getCompletedStateName() != null) {
            transition = new RestTransition();
            transition.completed = state.getCompletedStateName();
            restTransitionList.add(transition);
        }
        if (state.getStateSelections() != null && !state.getStateSelections().isEmpty()) {
            ArrayList<Condition> selectConditions = new ArrayList<Condition>();
            for (StateSelection stateSelection : state.getStateSelections()) {
                if (!stateSelection.isExplicit()) continue;
                selectConditions.addAll(stateSelection.getConditions());
                List<RestCondition> restConditions = stateSelection.getConditions().stream().map(Mappers.conditionMapper::toRest).filter(Objects::nonNull).collect(Collectors.toList());
                RestSelect restSelect = new RestSelect(Arrays.asList(stateSelection.getAllowedStatesNames()), restConditions);
                RestTransition transition2 = new RestTransition();
                transition2.select = restSelect;
                restTransitionList.add(transition2);
            }
        }
        if (restTransitionList.isEmpty()) {
            return null;
        }
        return restTransitionList;
    }

    private static /* synthetic */ boolean lambda$fromRest$9(RestTransition restTransition) {
        return StringUtils.isNotBlank((CharSequence)restTransition.completed);
    }

    private static /* synthetic */ boolean lambda$fromRest$7(RestTransition restTransition) {
        return StringUtils.isNotBlank((CharSequence)restTransition.expired);
    }

    private static /* synthetic */ boolean lambda$fromRest$5(RestTransition restTransition) {
        return StringUtils.isNotBlank((CharSequence)restTransition.updated);
    }

    private static /* synthetic */ boolean lambda$fromRest$3(RestTransition restTransition) {
        return StringUtils.isNotBlank((CharSequence)restTransition.rejected);
    }

    private static /* synthetic */ boolean lambda$fromRest$1(RestTransition restTransition) {
        return StringUtils.isNotBlank((CharSequence)restTransition.approved);
    }
}

