/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model;

import com.comalatech.confluence.workflow.restv2.model.RestCondition;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class RestConditionAdapter
extends XmlAdapter<List<AdaptedRestCondition>, List<RestCondition>> {
    public List<RestCondition> unmarshal(List<AdaptedRestCondition> adaptedConditions) {
        ArrayList<RestCondition> conditions = new ArrayList<RestCondition>();
        for (AdaptedRestCondition adaptedCondition : adaptedConditions) {
            RestCondition condition = this.createConditionInstance(adaptedCondition.type);
            if (condition == null) {
                throw new IllegalArgumentException("Unknown condition type: " + adaptedCondition.type);
            }
            condition.negate = adaptedCondition.negate;
            condition.value = adaptedCondition.value;
            if (condition instanceof RestCondition.HasApprovalCondition) {
                RestCondition.HasApprovalCondition approvalCondition = (RestCondition.HasApprovalCondition)condition;
                approvalCondition.current = adaptedCondition.current;
            } else if (condition instanceof RestCondition.ApproverCondition) {
                RestCondition.ApproverCondition approverCondition = (RestCondition.ApproverCondition)condition;
                approverCondition.minimum = adaptedCondition.minimum;
                approverCondition.approveType = adaptedCondition.approveType;
                approverCondition.conditionType = adaptedCondition.conditionType;
            } else if (condition instanceof RestCondition.MetadataCondition) {
                RestCondition.MetadataCondition metadataCondition = (RestCondition.MetadataCondition)condition;
                metadataCondition.comparedValue = adaptedCondition.comparedValue;
                metadataCondition.greaterThan = adaptedCondition.greaterThan;
                metadataCondition.lessThan = adaptedCondition.lessThan;
                metadataCondition.supplierReference = adaptedCondition.supplierReference;
            }
            conditions.add(condition);
        }
        return conditions;
    }

    public List<AdaptedRestCondition> marshal(List<RestCondition> conditions) {
        ArrayList<AdaptedRestCondition> adaptedRestConditions = new ArrayList<AdaptedRestCondition>();
        for (RestCondition condition : conditions) {
            AdaptedRestCondition adaptedRestCondition = new AdaptedRestCondition();
            adaptedRestCondition.type = this.getTypeName(condition);
            adaptedRestCondition.negate = condition.negate;
            adaptedRestCondition.value = condition.value;
            if (condition instanceof RestCondition.HasApprovalCondition) {
                RestCondition.HasApprovalCondition approvalCondition = (RestCondition.HasApprovalCondition)condition;
                adaptedRestCondition.current = approvalCondition.current;
            } else if (condition instanceof RestCondition.ApproverCondition) {
                RestCondition.ApproverCondition approverCondition = (RestCondition.ApproverCondition)condition;
                adaptedRestCondition.minimum = approverCondition.minimum;
                adaptedRestCondition.approveType = approverCondition.approveType;
                adaptedRestCondition.conditionType = approverCondition.conditionType;
            } else if (condition instanceof RestCondition.MetadataCondition) {
                RestCondition.MetadataCondition metadataCondition = (RestCondition.MetadataCondition)condition;
                adaptedRestCondition.comparedValue = metadataCondition.comparedValue;
                adaptedRestCondition.greaterThan = metadataCondition.greaterThan;
                adaptedRestCondition.lessThan = metadataCondition.lessThan;
                adaptedRestCondition.supplierReference = metadataCondition.supplierReference;
            }
            adaptedRestConditions.add(adaptedRestCondition);
        }
        return adaptedRestConditions;
    }

    private RestCondition createConditionInstance(String type) {
        switch (type) {
            case "permission": {
                return new RestCondition.PermissionCondition();
            }
            case "user": {
                return new RestCondition.UserCondition();
            }
            case "exclude": {
                return new RestCondition.ExcludeCondition();
            }
            case "allowedassignusers": {
                return new RestCondition.AllowedAssignerUserCondition();
            }
            case "allowedassigngroups": {
                return new RestCondition.AllowedAssignerGroupCondition();
            }
            case "page": {
                return new RestCondition.PageCondition();
            }
            case "space": {
                return new RestCondition.SpaceCondition();
            }
            case "state": {
                return new RestCondition.StateCondition();
            }
            case "stateindraft": {
                return new RestCondition.StateInDraftSpaceCondition();
            }
            case "group": {
                return new RestCondition.GroupCondition();
            }
            case "hasapproval": {
                return new RestCondition.HasApprovalCondition();
            }
            case "approver": {
                return new RestCondition.ApproverCondition();
            }
            case "haslabel": {
                return new RestCondition.HasLabelCondition();
            }
            case "parenthaslabel": {
                return new RestCondition.ParentHasLabelCondition();
            }
            case "metadata": {
                return new RestCondition.MetadataCondition();
            }
            case "hasViewWorkflow": {
                return new RestCondition.HasViewWorkflowPermissionCondition();
            }
            case "stateInitialized": {
                return new RestCondition.StateInitializedCondition();
            }
            case "usersdefined": {
                return new RestCondition.IsValueAsUserSetCondition();
            }
            case "title": {
                return new RestCondition.TitleCondition();
            }
            case "ishomepage": {
                return new RestCondition.IsHomePageCondition();
            }
            case "isorphan": {
                return new RestCondition.IsOrphanCondition();
            }
            case "ischildof": {
                return new RestCondition.IsChildOfCondition();
            }
            case "isAssignment": {
                return new RestCondition.IsAssignmentCondition();
            }
            case "isminorchange": {
                return new RestCondition.IsMinorChangeCondition();
            }
            case "hasPendingTasks": {
                return new RestCondition.HasPendingTasksCondition();
            }
        }
        return null;
    }

    private String getTypeName(RestCondition condition) {
        if (condition instanceof RestCondition.PermissionCondition) {
            return "permission";
        }
        if (condition instanceof RestCondition.UserCondition) {
            return "user";
        }
        if (condition instanceof RestCondition.ExcludeCondition) {
            return "exclude";
        }
        if (condition instanceof RestCondition.AllowedAssignerUserCondition) {
            return "allowedassignusers";
        }
        if (condition instanceof RestCondition.AllowedAssignerGroupCondition) {
            return "allowedassigngroups";
        }
        if (condition instanceof RestCondition.PageCondition) {
            return "page";
        }
        if (condition instanceof RestCondition.SpaceCondition) {
            return "space";
        }
        if (condition instanceof RestCondition.StateCondition) {
            return "state";
        }
        if (condition instanceof RestCondition.StateInDraftSpaceCondition) {
            return "stateindraft";
        }
        if (condition instanceof RestCondition.GroupCondition) {
            return "group";
        }
        if (condition instanceof RestCondition.HasApprovalCondition) {
            return "hasapproval";
        }
        if (condition instanceof RestCondition.ApproverCondition) {
            return "approver";
        }
        if (condition instanceof RestCondition.HasLabelCondition) {
            return "haslabel";
        }
        if (condition instanceof RestCondition.ParentHasLabelCondition) {
            return "parenthaslabel";
        }
        if (condition instanceof RestCondition.MetadataCondition) {
            return "metadata";
        }
        if (condition instanceof RestCondition.HasViewWorkflowPermissionCondition) {
            return "hasViewWorkflow";
        }
        if (condition instanceof RestCondition.StateInitializedCondition) {
            return "stateInitialized";
        }
        if (condition instanceof RestCondition.IsValueAsUserSetCondition) {
            return "usersdefined";
        }
        if (condition instanceof RestCondition.TitleCondition) {
            return "title";
        }
        if (condition instanceof RestCondition.IsHomePageCondition) {
            return "ishomepage";
        }
        if (condition instanceof RestCondition.IsOrphanCondition) {
            return "isorphan";
        }
        if (condition instanceof RestCondition.IsChildOfCondition) {
            return "ischildof";
        }
        if (condition instanceof RestCondition.IsAssignmentCondition) {
            return "isAssignment";
        }
        if (condition instanceof RestCondition.IsMinorChangeCondition) {
            return "isminorchange";
        }
        if (condition instanceof RestCondition.HasPendingTasksCondition) {
            return "hasPendingTasks";
        }
        return null;
    }

    public static class AdaptedRestCondition {
        public String type;
        public Boolean negate;
        public String value;
        public Boolean current;
        public String comparedValue;
        public Boolean greaterThan;
        public Boolean lessThan;
        public Boolean supplierReference;
        public String conditionType;
        public String minimum;
        public RestCondition.ApproverCondition.ApproveType approveType;
    }
}

