/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.mywork;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.workflow.mywork.NotificationServiceAccessor;
import com.comalatech.confluence.workflow.mywork.NotificationServiceFactory;
import com.comalatech.confluence.workflow.mywork.NotificationServiceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class NotificationServiceAccessorImpl
implements NotificationServiceAccessor {
    private static final Logger log = LoggerFactory.getLogger(NotificationServiceAccessorImpl.class);
    private final ApplicationContext applicationContext;
    private NotificationServiceHolder notificationServiceHolder;

    public NotificationServiceAccessorImpl(@ComponentImport ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public synchronized NotificationServiceHolder getNotificationService() {
        if (this.notificationServiceHolder == null || this.notificationServiceHolder.getNotificationService() == null) {
            this.initNotificationService();
        }
        return this.notificationServiceHolder;
    }

    private void initNotificationService() {
        try {
            Class<?> notificationServiceFactoryClass = this.getNotificationServiceFactoryClass();
            if (notificationServiceFactoryClass != null) {
                this.notificationServiceHolder = ((NotificationServiceFactory)this.applicationContext.getAutowireCapableBeanFactory().createBean(notificationServiceFactoryClass, 3, false)).get();
            }
        }
        catch (Exception e) {
            log.debug("Could not create Foo", (Throwable)e);
        }
    }

    private Class<?> getNotificationServiceFactoryClass() {
        try {
            this.getClass().getClassLoader().loadClass("com.atlassian.mywork.service.NotificationService");
            return this.getClass().getClassLoader().loadClass("com.comalatech.confluence.workflow.mywork.NotificationServiceFactory");
        }
        catch (Exception e) {
            log.info("The necessary mywork class is unavailable.");
            return null;
        }
    }
}

