/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.Entity;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.AbstractUserGroupApproverCondition;
import com.comalatech.confluence.workflow.model.Selector;
import com.comalatech.confluence.workflow.model.ValueReference;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class GroupCondition
extends AbstractUserGroupApproverCondition {
    private static final Logger log = LoggerFactory.getLogger(GroupCondition.class);
    private String[] groupNames;

    public GroupCondition(boolean not, String groupsList) {
        super(not);
        this.groupNames = GroupCondition.makeValues(groupsList);
    }

    @Override
    protected boolean evaluateBinary(ValueStore valueStore) throws WorkflowException {
        ConfluenceUser user = this.getUser();
        if (user == null) {
            return false;
        }
        for (String group : this.groupNames) {
            List<Group> referredGroups = this.getUsersListResolver().getValueAsGroups(valueStore, group);
            for (Group referredGroup : referredGroups) {
                try {
                    if (!this.getGroupManager().hasMembership(referredGroup, (User)user)) continue;
                    return true;
                }
                catch (Exception e) {
                    log.error("There has been an error checking the membership for user {}: {}", (Object)user, (Object)e.getMessage());
                }
            }
        }
        return false;
    }

    @Override
    public void addMacroParameters(SerializableMacro macro) {
        macro.addParameter("group", (Object)((this.not ? "!" : "") + MiscUtils.stringListToCommaSeparatedList(this.groupNames, ",")));
    }

    @Override
    public String toString(ValueStore valueStore) {
        StringBuffer sb = new StringBuffer("user is ");
        if (this.not) {
            sb.append("not ");
        }
        sb.append("in group ").append(ValueReference.referenceToString(StringUtils.arrayToCommaDelimitedString((Object[])this.groupNames), valueStore));
        return sb.toString();
    }

    public String[] getGroupNames() {
        return this.groupNames;
    }

    public String toString() {
        return this.toString(null);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GroupCondition)) {
            return false;
        }
        GroupCondition g = (GroupCondition)o;
        return this.not == g.not && Arrays.equals(this.groupNames, g.groupNames);
    }

    @Override
    public Collection<Entity> getSelectableUsersOrGroups(ValueStore valueStore, Selector selector) throws WorkflowException {
        return this.getUsersListResolver().getValueAsUsersOrGroups(valueStore, String.join((CharSequence)",", this.groupNames));
    }

    @Override
    public ConfluenceUser[] getSelectableUsers(ValueStore valueStore, Selector selector, boolean ignoreExceptions) throws WorkflowException {
        return this.getUsersListResolver().getValueAsUsers(valueStore, valueStore.getPage(), String.join((CharSequence)",", this.groupNames), ignoreExceptions);
    }
}

