/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflowreports.ActivityManager;
import com.comalatech.workflow.event.WorkflowEvent;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class WorkflowLastActivityListener
extends WorkflowsListener {
    protected final ActivityManager activityManager;

    public WorkflowLastActivityListener(@ComponentImport EventPublisher eventPublisher, ActivityManager activityManager) {
        super(eventPublisher);
        this.activityManager = activityManager;
    }

    @EventListener
    public void workflowEvent(WorkflowEvent event) {
        if (event.getContent() != null && event.getContent() instanceof AbstractPage) {
            this.activityManager.setRecentActivityDateCache((ContentEntityObject)((AbstractPage)event.getContent()), new Date());
        }
    }

    @EventListener
    public void pageCreatedEvent(PageCreateEvent event) {
        this.confluenceContentEvent((ContentEvent)event);
    }

    @EventListener
    public void blogCreateEvent(BlogPostCreateEvent event) {
        this.confluenceContentEvent((ContentEvent)event);
    }

    @EventListener
    public void pageUpdatedEvent(PageUpdateEvent event) {
        this.confluenceContentEvent((ContentEvent)event);
    }

    @EventListener
    public void blogUpdatedEvent(BlogPostUpdateEvent event) {
        this.confluenceContentEvent((ContentEvent)event);
    }

    protected void confluenceContentEvent(ContentEvent event) {
        this.activityManager.setRecentActivityDateCache(event.getContent(), new Date());
    }
}

