/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.workflow.template.LinkedTemplateManager;
import java.util.List;
import java.util.Properties;

public class SpaceCreatedFromJunoviBlueprintListener
extends WorkflowsListener {
    protected final LinkedTemplateManager linkedTemplateManager;
    private final String BPC_EVENT_EMITTER = "net.junovi.confluence.blueprint-creator.SpaceFromBlueprintCreated";

    public SpaceCreatedFromJunoviBlueprintListener(@ComponentImport EventPublisher eventPublisher, LinkedTemplateManager linkedTemplateManager) {
        super(eventPublisher);
        this.linkedTemplateManager = linkedTemplateManager;
    }

    @EventListener
    public void handlePossibleBlueprintCreatorEvent(Properties properties) {
        if ("net.junovi.confluence.blueprint-creator.SpaceFromBlueprintCreated".equals(properties.getProperty("_emitter"))) {
            this.handleBlueprintCreatorEvent(properties);
        }
    }

    public void handleBlueprintCreatorEvent(Properties properties) {
        String categoryList = properties.getProperty("categories");
        String spaceKey = properties.getProperty("spaceKey");
        String[] categories = categoryList.trim().split(",");
        if (categories.length > 0 && categories[0].length() > 0) {
            for (String cat : categories) {
                List<String> workflowNames = this.linkedTemplateManager.getLinkedLabelTemplateNames(cat);
                for (String workflowName : workflowNames) {
                    this.linkedTemplateManager.addTemplateLink(spaceKey, workflowName);
                }
            }
        }
    }
}

