/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.esignatures.configuration;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.dao.ComalatechBandanaContext;
import com.comalatech.confluence.workflow.esignatures.model.ESignatureCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ESignaturesConfigurationManager {
    private static final Logger log = LoggerFactory.getLogger(ESignaturesConfigurationManager.class);
    private static final String CONFIG_ESIGNATURES_CREDENTIALS_KEY = "com.comalatech.workflow.esignatures.credentials";
    private static final String DEFAULT_ESIGNATURES_CREDENTIALS = "confluence";
    private final BandanaManager bandanaManager;
    private final BandanaContext bandanaContext = ComalatechBandanaContext.COMALATECH_CONTEXT;

    public ESignaturesConfigurationManager(@ComponentImport BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public String getESignaturesCredentials() {
        String eSignaturesCredentials = (String)this.bandanaManager.getValue(this.bandanaContext, CONFIG_ESIGNATURES_CREDENTIALS_KEY);
        ESignatureCredentials.Credentials credentials = ESignatureCredentials.Credentials.fromString(eSignaturesCredentials);
        return credentials != null ? credentials.getValue() : DEFAULT_ESIGNATURES_CREDENTIALS;
    }

    public void setESignaturesCredentials(String eSignaturesCredentials) {
        ESignatureCredentials.Credentials parsedCredentials = ESignatureCredentials.Credentials.fromString(eSignaturesCredentials);
        if (parsedCredentials != null) {
            this.bandanaManager.setValue(this.bandanaContext, CONFIG_ESIGNATURES_CREDENTIALS_KEY, (Object)parsedCredentials.getValue());
            if (log.isDebugEnabled()) {
                log.debug("E-Signatures Credentials configuration saved : " + parsedCredentials);
            }
        } else {
            log.error("Invalid E-Signatures Credentials");
        }
    }
}

