/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.esignatures.ao.accesor;

import com.comalatech.confluence.util.ActiveObjectsAccessor;
import com.comalatech.confluence.workflow.esignatures.ao.SigningRecordDeleteCriteria;
import com.comalatech.confluence.workflow.esignatures.ao.accesor.SigningTokenRecordAccessor;
import com.comalatech.confluence.workflow.esignatures.ao.entity.BaseSigningTokenRecord;
import com.comalatech.confluence.workflow.esignatures.ao.entity.SigningTokenRecordEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.java.ao.DBParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SigningTokenRecordAccessorImpl
extends ActiveObjectsAccessor
implements SigningTokenRecordAccessor {
    private static final Logger log = LoggerFactory.getLogger(SigningTokenRecordAccessorImpl.class);

    @Override
    public BaseSigningTokenRecord save(BaseSigningTokenRecord record) {
        return (BaseSigningTokenRecord)this.getAo().executeInTransaction(() -> this.createRecord(record));
    }

    private BaseSigningTokenRecord createRecord(BaseSigningTokenRecord record) {
        SigningTokenRecordEntity entity = (SigningTokenRecordEntity)this.getAo().create(SigningTokenRecordEntity.class, new DBParam[]{new DBParam("USER_KEY", (Object)record.getUserKey()), new DBParam("SECRET_KEY", (Object)record.getSecretKey()), new DBParam("CREATED_TIMESTAMP", (Object)record.getCreatedTimestamp()), new DBParam("EXPIRY_TIMESTAMP", (Object)record.getExpiryTimestamp()), new DBParam("LAST_SUCCESS", (Object)record.getLastSuccess()), new DBParam("FAILED_ATTEMPTS", (Object)record.getFailedAttempts())});
        entity.save();
        if (log.isDebugEnabled()) {
            log.debug("Signing Token record has been created: \n" + record.toString());
        }
        return entity;
    }

    @Override
    public BaseSigningTokenRecord get(String userKey) {
        List<BaseSigningTokenRecord> baseSigningTokenRecords = Arrays.asList((BaseSigningTokenRecord[])this.getAo().find(SigningTokenRecordEntity.class, "USER_KEY = ?", new Object[]{userKey}));
        return baseSigningTokenRecords != null && !baseSigningTokenRecords.isEmpty() ? baseSigningTokenRecords.get(0) : null;
    }

    @Override
    public void delete(SigningRecordDeleteCriteria criteria) {
        if (criteria.getUserKey() != null) {
            this.getAo().deleteWithSQL(SigningTokenRecordEntity.class, this.buildDeleteQuery(criteria), new Object[0]);
        } else {
            log.warn("Trying to delete empty user in signing tokens. skipping");
        }
    }

    @Override
    public List<BaseSigningTokenRecord> getAll() {
        return Arrays.asList((BaseSigningTokenRecord[])this.getAo().find(SigningTokenRecordEntity.class));
    }

    @Override
    public BaseSigningTokenRecord update(BaseSigningTokenRecord baseSigningTokenRecord) {
        return (BaseSigningTokenRecord)this.getAo().executeInTransaction(() -> this.updateRecord(baseSigningTokenRecord));
    }

    private BaseSigningTokenRecord updateRecord(BaseSigningTokenRecord record) {
        SigningTokenRecordEntity storedTokenRecord = record.getId() == null ? (SigningTokenRecordEntity)this.get(record.getUserKey()) : (SigningTokenRecordEntity)this.getAo().get(SigningTokenRecordEntity.class, (Object)record.getId());
        if (!Objects.equals(record.getFailedAttempts(), storedTokenRecord.getFailedAttempts())) {
            storedTokenRecord.setFailedAttempts(record.getFailedAttempts());
        }
        if (record.getExpiryTimestamp() != null && !Objects.equals(record.getExpiryTimestamp(), storedTokenRecord.getExpiryTimestamp())) {
            storedTokenRecord.setExpiryTimestamp(record.getExpiryTimestamp());
        }
        if (!Objects.equals(record.getLastSuccess(), storedTokenRecord.getLastSuccess())) {
            storedTokenRecord.setLastSuccess(record.getLastSuccess());
        }
        storedTokenRecord.save();
        if (log.isDebugEnabled()) {
            log.debug("Signing record has been updated: \n" + record.toString());
        }
        return storedTokenRecord;
    }

    private String buildDeleteQuery(SigningRecordDeleteCriteria deleteCriteria) {
        ArrayList<String> values = new ArrayList<String>();
        Object queryClause = "";
        if (deleteCriteria.getUserKey() != null) {
            queryClause = "USER_KEY = '" + deleteCriteria.getUserKey() + "'";
            values.add(deleteCriteria.getUserKey());
        }
        return queryClause;
    }
}

