/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.documentReport;

import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.comalatech.confluence.documentActions.rest.model.ActionReport;
import com.comalatech.confluence.documentActions.rest.model.DocumentActionsReport;
import com.comalatech.confluence.documentActions.services.DocumentActionsServiceImpl;
import com.comalatech.confluence.documentActions.services.model.ActionsSearchResult;
import com.comalatech.confluence.documentActions.services.model.DocumentActionsSearchResult;
import com.comalatech.confluence.documentActions.services.model.PendingApprovals;
import com.comalatech.confluence.workflow.documentReport.DocumentReportBuilder;
import com.comalatech.confluence.workflow.restv2.model.documentreport.ActionsReportDetail;
import com.comalatech.confluence.workflow.restv2.model.documentreport.ContentData;
import com.comalatech.confluence.workflow.restv2.model.documentreport.DocumentReport;
import com.comalatech.confluence.workflow.restv2.model.documentreport.WorkflowsReportData;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="actionsReportBuilder")
public class ActionsReportBuilder
implements DocumentReportBuilder {
    private static final Logger log = LoggerFactory.getLogger(ActionsReportBuilder.class);
    private final DocumentActionsServiceImpl documentActionsService;
    private final UserAccessor userAccessor;

    public ActionsReportBuilder(DocumentActionsServiceImpl documentActionsService, @ComponentImport UserAccessor userAccessor) {
        this.documentActionsService = documentActionsService;
        this.userAccessor = userAccessor;
    }

    @Override
    public DocumentReport build(SearchPageResponse<SearchResult> searchResults) {
        DocumentReport documentReport = new DocumentReport();
        try {
            String userKey = StringUtils.substringBetween((String)searchResults.getCqlQuery(), (String)"userKeyList IN (\"", (String)"\")");
            DocumentActionsReport documentActions = this.processDocumentActions(this.documentActionsService.buildDocumentActionsSearchResultFrom(searchResults, this.userAccessor.getUserByKey(new UserKey(userKey))));
            this.setPaginationMetadata(searchResults, documentReport);
            HashMap workflowsReportDataMap = new HashMap();
            documentActions.getDocumentActions().forEach(documentAction -> {
                WorkflowsReportData workflowsReportData = workflowsReportDataMap.computeIfAbsent(documentAction.getContentDetails().getId(), id -> {
                    WorkflowsReportData newData = new WorkflowsReportData();
                    newData.setContentData(this.createContentData((ActionReport)documentAction));
                    newData.setActions(new ArrayList<ActionsReportDetail>());
                    return newData;
                });
                workflowsReportData.getActions().add(this.createActionDetail((ActionReport)documentAction));
            });
            documentReport.setWorkflowsReportList(new ArrayList<WorkflowsReportData>(workflowsReportDataMap.values()));
        }
        catch (Exception ex) {
            log.warn("Could not be able to parse report data from CQL response {} ", searchResults, (Object)ex);
        }
        return documentReport;
    }

    private void setPaginationMetadata(SearchPageResponse<SearchResult> searchResults, DocumentReport documentReport) {
        documentReport.setLimit(searchResults.getPageRequest().getLimit());
        documentReport.setStart(searchResults.getPageRequest().getStart());
        documentReport.setSize(searchResults.size());
        documentReport.setTotalSize(searchResults.totalSize());
    }

    private DocumentActionsReport processDocumentActions(DocumentActionsSearchResult documentActionsInput) {
        DocumentActionsReport documentActionsOutput = new DocumentActionsReport();
        for (ActionsSearchResult actionResult : documentActionsInput.getActionsSearchResults()) {
            ArrayList<ActionReport> actionsOutput = new ArrayList<ActionReport>();
            actionsOutput.addAll(actionResult.getPendingApprovals());
            actionsOutput.addAll(actionResult.getPendingTasks());
            documentActionsOutput.addDocumentActions(actionsOutput);
        }
        return documentActionsOutput;
    }

    private ContentData createContentData(ActionReport documentAction) {
        ActionReport.ContentDetails contentDetails = documentAction.getContentDetails();
        ContentData contentData = new ContentData();
        contentData.setTitle(contentDetails.getTitle());
        contentData.setId(contentDetails.getId());
        contentData.setType(contentDetails.getType());
        contentData.setSpaceTitle(contentDetails.getSpaceName());
        contentData.setUrl(contentDetails.getUrl());
        return contentData;
    }

    private ActionsReportDetail createActionDetail(ActionReport documentAction) {
        ActionsReportDetail reportDetail = ActionsReportDetail.builder().id(documentAction.getId()).type(documentAction.getType()).name(documentAction.getName()).details(documentAction.getDetails()).dueDate(documentAction.getDueDate()).assignmentDate(documentAction.getAssignmentDate()).assignerDetails(documentAction.getAssignerDetails()).build();
        if (documentAction instanceof PendingApprovals) {
            reportDetail.setHasCondition(((PendingApprovals)documentAction).isHasCondition());
        }
        return reportDetail;
    }
}

