/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.dao.sax;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.util.XMLUtils;
import com.atlassian.sal.api.user.UserKey;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.dao.DaoHelper;
import com.comalatech.confluence.workflow.esignatures.model.ESignatureCredentials;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.workflow.model.SignatureType;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ApprovalChecksConverter
extends DefaultHandler {
    private static final String APPROVAL_CHECK_1_4_QNAME = "com.comalatech.confluence.workflow.model.ApprovalCheck";
    private static final String CHECKED_ATTACHMENT_1_4_QNAME = "com.comalatech.confluence.workflow.model.ApprovalCheck-CheckedAttachment";
    private static final String APPROVAL_CHECKS_QNAME = "ApprovalChecks";
    private static final String APPROVAL_CHECK_QNAME = "ApprovalCheck";
    private static final String CHECKED_ATTACHMENT_QNAME = "CheckedAttachment";
    private static final String APPROVER_QNAME = "Approver";
    private static final String NAME_QNAME = "name";
    private static final String APPROVED_QNAME = "approved";
    private static final String VERSION_QNAME = "version";
    private static final String USER_QNAME = "user";
    private static final String ROLE_QNAME = "rolename";
    private static final String DATE_QNAME = "date";
    private static final String COMMENT_QNAME = "comment";
    private static final String WEIGHT_QNAME = "weight";
    private static final String ID_QNAME = "id";
    private static final String STATEID_QNAME = "stateId";
    private static final String NEXTAPPROVALUSERS_1_4_QNAME = "nextApprovalUsers";
    private static final String ATTACHMENTS_QNAME = "attachments";
    private static final String APPROVERS_QNAME = "approvers";
    private static final String REQUIRED_APPROVERS_QNAME = "requiredApprovers";
    private static final String NEXTAPPROVERS_QNAME = "nextApprovers";
    private static final String CAPTION_QNAME = "caption";
    private static final String STRING_QNAME = "string";
    private static final String ASSIGNEE_HISTORIES_QNAME = "assigneeHistories";
    private static final String ASSIGNEE_HISTORY_QNAME = "asssigneeHistory";
    private static final String AH_DATE_QNAME = "assignedDate";
    private static final String AH_ASSIGNER_QNAME = "assignerUserName";
    private static final String AH_TYPE_QNAME = "assigneeHistoryType";
    private static final String MINIMUM_APPROVERS_QNAME = "minimumApprovers";
    private static final String SIGNATURE_TYPE_QNAME = "signature";
    private static final String ESIGNATURE_TYPE_QNAME = "esignature";
    private StringBuffer value;
    private ApprovalCheck approvalCheck;
    private List approvalsChecks;
    private List checkAttachments;
    private List users;
    private long attachmentId;
    private int attachmentversion;
    private boolean inCheckedAttachment;
    private boolean approved;
    private String user;
    private String rolename;
    private Date date;
    private String comment;
    private int nApprovers;
    private List<ApprovalCheck.AssigneeHistory> assigneeHistories;
    private DueDateRecord dueDateRecord;
    private ApprovalCheck.AssigneeHistory assigneeHistory;
    private String assigner;
    private ApprovalCheck.AssigneeHistoryType ahType;
    private SignatureType signatureType;
    private ESignatureCredentials.Credentials eSignature;
    protected final UserAccessor userAccessor;
    protected Map<String, String> userCache;

    public ApprovalChecksConverter(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
        this.userCache = new HashMap<String, String>();
    }

    @Override
    public void startDocument() {
        this.value = new StringBuffer();
        this.approvalsChecks = new ArrayList();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.value = new StringBuffer();
        if (APPROVAL_CHECK_1_4_QNAME.equals(qName) || APPROVAL_CHECK_QNAME.equals(qName)) {
            this.approvalCheck = new ApprovalCheck();
            this.checkAttachments = new ArrayList();
            this.users = new ArrayList();
            this.inCheckedAttachment = false;
            this.nApprovers = 0;
        } else if (CHECKED_ATTACHMENT_1_4_QNAME.equals(qName) || CHECKED_ATTACHMENT_QNAME.equals(qName)) {
            this.inCheckedAttachment = true;
        } else if (REQUIRED_APPROVERS_QNAME.equals(qName) || NEXTAPPROVALUSERS_1_4_QNAME.equals(qName) || NEXTAPPROVERS_QNAME.equals(qName)) {
            this.users = new ArrayList();
        } else if (ASSIGNEE_HISTORIES_QNAME.equals(qName)) {
            this.assigneeHistories = new ArrayList<ApprovalCheck.AssigneeHistory>();
        } else if (ASSIGNEE_HISTORY_QNAME.equals(qName)) {
            this.users = new ArrayList();
            this.assigneeHistory = new ApprovalCheck.AssigneeHistory(null, null, null, null, null, null);
        } else if (AH_TYPE_QNAME.equals(qName)) {
            this.ahType = null;
        } else if ("currentDueDateRecord".equals(qName) || "dueDateRecord".equals(qName)) {
            try {
                this.dueDateRecord = new DueDateRecord(this.getUserName(attributes.getValue(USER_QNAME)), this.getDate(attributes.getValue(DATE_QNAME)));
            }
            catch (ParseException e) {
                throw new SAXException("error parsing date", e);
            }
        }
    }

    private String getUserName(String userNameOrKey) {
        String returnUser = this.userCache.get(userNameOrKey);
        if (returnUser == null) {
            ConfluenceUser user = this.userAccessor.getUserByName(userNameOrKey);
            if (user == null) {
                user = this.userAccessor.getUserByKey(new UserKey(userNameOrKey));
            }
            returnUser = user == null ? userNameOrKey : user.getName();
            this.userCache.put(userNameOrKey, returnUser);
        }
        return returnUser;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (APPROVAL_CHECK_1_4_QNAME.equals(qName) || APPROVAL_CHECK_QNAME.equals(qName)) {
            this.approvalsChecks.add(this.approvalCheck);
        } else if (APPROVER_QNAME.equals(qName)) {
            this.approvalCheck.addApprover(new Approver(this.approvalCheck.getName(), this.user, this.rolename, this.date, this.comment, this.approved, this.signatureType, this.eSignature));
            ++this.nApprovers;
        } else if (CHECKED_ATTACHMENT_1_4_QNAME.equals(qName) || CHECKED_ATTACHMENT_QNAME.equals(qName)) {
            this.checkAttachments.add(this.approvalCheck.createCheckedAttachment(this.attachmentId, this.attachmentversion));
            this.inCheckedAttachment = false;
        } else if (ATTACHMENTS_QNAME.equals(qName)) {
            this.approvalCheck.setCheckedAttachments(this.checkAttachments);
        } else if (REQUIRED_APPROVERS_QNAME.equals(qName)) {
            this.approvalCheck.setRequiredApprovers(this.users.toArray(new String[this.users.size()]));
        } else if (NEXTAPPROVALUSERS_1_4_QNAME.equals(qName) || NEXTAPPROVERS_QNAME.equals(qName)) {
            this.approvalCheck.setNextApprovers(this.users.toArray(new String[this.users.size()]));
        } else if (NAME_QNAME.equals(qName)) {
            this.approvalCheck.setName(this.getValue());
        } else if (VERSION_QNAME.equals(qName)) {
            int ver = Integer.parseInt(this.getValue());
            if (this.inCheckedAttachment) {
                this.attachmentversion = ver;
            } else {
                this.approvalCheck.setVersion(ver);
            }
        } else if (APPROVED_QNAME.equals(qName)) {
            this.approved = this.getValue().equals(Boolean.TRUE.toString());
        } else if (USER_QNAME.equals(qName)) {
            this.user = this.getUserName(this.getValue());
            this.users.add(this.user);
        } else if (ROLE_QNAME.equals(qName)) {
            this.rolename = this.getValue();
        } else {
            if (DATE_QNAME.equals(qName) || AH_DATE_QNAME.equals(qName)) {
                try {
                    this.date = TimerUtils.parseDate(this.getValue());
                }
                catch (ParseException e) {
                    throw new SAXException(e.getMessage());
                }
            }
            if (COMMENT_QNAME.equals(qName)) {
                this.comment = this.getValue();
            } else if (WEIGHT_QNAME.equals(qName)) {
                this.approvalCheck.setWeight(Integer.parseInt(this.getValue()));
            } else if (CAPTION_QNAME.equals(qName)) {
                this.approvalCheck.setCaption(this.getValue());
            } else if (ID_QNAME.equals(qName)) {
                long id = Long.parseLong(this.getValue());
                if (this.inCheckedAttachment) {
                    this.attachmentId = id;
                } else {
                    this.approvalCheck.setId((int)id);
                }
            } else if (STATEID_QNAME.equals(qName)) {
                this.approvalCheck.setStateId(Integer.parseInt(this.getValue()));
            } else if (STRING_QNAME.equals(qName)) {
                this.users.add(this.getValue());
            } else if (ASSIGNEE_HISTORIES_QNAME.equals(qName)) {
                this.approvalCheck.setAssigneeHistory(this.assigneeHistories);
            } else if (ASSIGNEE_HISTORY_QNAME.equals(qName)) {
                this.assigneeHistory.setAssignee(this.user);
                this.assigneeHistory.setRolename(this.rolename);
                this.assigneeHistory.setDate(this.date);
                this.assigneeHistory.setUserName(this.assigner);
                this.assigneeHistory.setComment(this.comment);
                this.assigneeHistory.setType(this.ahType);
                this.assigneeHistories.add(this.assigneeHistory);
            } else if (AH_ASSIGNER_QNAME.equals(qName)) {
                this.assigner = this.getUserName(this.getValue());
            } else if (AH_TYPE_QNAME.equals(qName)) {
                this.ahType = ApprovalCheck.AssigneeHistoryType.valueOf(this.getValue());
            } else if (MINIMUM_APPROVERS_QNAME.equals(qName)) {
                this.approvalCheck.setMinimumApproversRequired(Integer.parseInt(this.getValue()));
            } else if ("expiryTriggered".equals(qName)) {
                this.dueDateRecord.setExpiryTriggered(Boolean.valueOf(this.getValue()));
            } else {
                if ("duedate".equals(qName)) {
                    try {
                        this.dueDateRecord.setDueDate(this.getDate(this.getValue()));
                    }
                    catch (ParseException e) {
                        throw new SAXException("error parsing date", e);
                    }
                }
                if (SIGNATURE_TYPE_QNAME.equals(qName)) {
                    int signatureTypeId = SignatureType.NONE.getId();
                    try {
                        signatureTypeId = Integer.parseInt(this.getValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.signatureType = SignatureType.lookupById(signatureTypeId);
                } else if (ESIGNATURE_TYPE_QNAME.equals(qName)) {
                    this.eSignature = ESignatureCredentials.Credentials.fromString(this.getValue());
                }
            }
        }
    }

    public ApprovalCheck getApprovalCheck() {
        return this.approvalCheck;
    }

    public ApprovalCheck[] getApprovalChecks() {
        return this.approvalsChecks.toArray(new ApprovalCheck[this.approvalsChecks.size()]);
    }

    public String getValue() {
        return this.value.toString();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.value.append(ch, start, length);
    }

    public static String convertToXml(ApprovalCheck[] approvalChecks) {
        if (approvalChecks == null || approvalChecks.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> userNamesCache = new HashMap<String, String>();
        sb.append("<").append(APPROVAL_CHECKS_QNAME).append(">\n");
        for (ApprovalCheck approvalCheck : approvalChecks) {
            sb.append(ApprovalChecksConverter.convertToXml(approvalCheck, userNamesCache));
        }
        sb.append("</").append(APPROVAL_CHECKS_QNAME).append(">\n");
        return sb.toString();
    }

    public static String convertToXml(ApprovalCheck approvalCheck) {
        return ApprovalChecksConverter.convertToXml(approvalCheck, new HashMap<String, String>());
    }

    private static String convertToXml(ApprovalCheck approvalCheck, Map<String, String> userNamesCache) {
        if (approvalCheck == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("  <").append(APPROVAL_CHECK_QNAME).append(">\n");
        ApprovalChecksConverter.appendAttribute(sb, NAME_QNAME, approvalCheck.getName());
        ApprovalChecksConverter.appendAttribute(sb, VERSION_QNAME, Integer.toString(approvalCheck.getVersion()));
        Approver[] approvers = approvalCheck.getApprovers();
        sb.append("    <").append(APPROVERS_QNAME).append(">\n");
        for (int j = 0; j < approvers.length; ++j) {
            Approver approver = approvers[j];
            sb.append("      <").append(APPROVER_QNAME).append(">\n");
            sb.append("    ");
            ApprovalChecksConverter.appendAttribute(sb, APPROVED_QNAME, Boolean.toString(approver.isApproved()));
            sb.append("    ");
            ApprovalChecksConverter.appendAttribute(sb, USER_QNAME, DaoHelper.getUserNameOrKey(approver.getUser(), userNamesCache));
            sb.append("    ");
            ApprovalChecksConverter.appendAttribute(sb, ROLE_QNAME, approver.getRole());
            sb.append("    ");
            ApprovalChecksConverter.appendAttribute(sb, DATE_QNAME, TimerUtils.getFormatter().format(approver.getDate()));
            sb.append("    ");
            ApprovalChecksConverter.appendAttribute(sb, COMMENT_QNAME, approver.getComment()).append("\n");
            if (approver.getSignatureType() != null) {
                sb.append("    ");
                ApprovalChecksConverter.appendAttribute(sb, SIGNATURE_TYPE_QNAME, "" + approver.getSignatureType().getId());
            }
            if (approver.getESignature() != null) {
                sb.append("    ");
                ApprovalChecksConverter.appendAttribute(sb, ESIGNATURE_TYPE_QNAME, approver.getESignature().getValue());
            }
            sb.append("      </").append(APPROVER_QNAME).append(">\n");
        }
        sb.append("    </").append(APPROVERS_QNAME).append(">\n");
        ApprovalChecksConverter.appendAttribute(sb, WEIGHT_QNAME, Integer.toString(approvalCheck.getWeight()));
        ApprovalChecksConverter.appendAttribute(sb, ID_QNAME, Integer.toString(approvalCheck.getId()));
        ApprovalChecksConverter.appendAttribute(sb, STATEID_QNAME, Integer.toString(approvalCheck.getStateId()));
        ApprovalCheck.CheckedAttachment[] checkedattachments = approvalCheck.getAttachments();
        if (checkedattachments == null || checkedattachments.length == 0) {
            sb.append("    <").append(ATTACHMENTS_QNAME).append("/>\n");
        } else {
            sb.append("    <").append(ATTACHMENTS_QNAME).append(">\n");
            for (int j = 0; j < checkedattachments.length; ++j) {
                sb.append("      <").append(CHECKED_ATTACHMENT_1_4_QNAME).append(">\n");
                ApprovalCheck.CheckedAttachment checkedattachment = checkedattachments[j];
                sb.append("    ");
                ApprovalChecksConverter.appendAttribute(sb, ID_QNAME, Long.toString(checkedattachment.getId()));
                sb.append("    ");
                ApprovalChecksConverter.appendAttribute(sb, VERSION_QNAME, Integer.toString(checkedattachment.getVersion()));
                sb.append("        <outer-class refercence=\"../../..\"/>\n");
                sb.append("      </").append(CHECKED_ATTACHMENT_1_4_QNAME).append(">\n");
            }
            sb.append("    </").append(ATTACHMENTS_QNAME).append(">\n");
        }
        if (StringUtils.isNotBlank((CharSequence)approvalCheck.getCaption())) {
            ApprovalChecksConverter.appendAttribute(sb, CAPTION_QNAME, approvalCheck.getCaption());
        }
        ApprovalChecksConverter.addUsersList(sb, approvalCheck.getRequiredApprovers(), REQUIRED_APPROVERS_QNAME, userNamesCache);
        ApprovalChecksConverter.appendAttribute(sb, MINIMUM_APPROVERS_QNAME, Integer.toString(approvalCheck.getMinimumApproversRequired()));
        ApprovalChecksConverter.addAssigneeHistories(sb, approvalCheck.getAssigneeHistory(), userNamesCache);
        sb.append("  </").append(APPROVAL_CHECK_QNAME).append(">\n");
        return sb.toString();
    }

    private static void addUsersList(StringBuilder sb, String[] approverNames, String qname, Map<String, String> userNamesCache) {
        if (approverNames != null && approverNames.length > 0) {
            sb.append("    <").append(qname).append(">\n");
            for (int k = 0; k < approverNames.length; ++k) {
                String user = approverNames[k];
                sb.append("  ");
                ApprovalChecksConverter.appendAttribute(sb, USER_QNAME, DaoHelper.getUserNameOrKey(user, userNamesCache));
            }
            sb.append("    </").append(qname).append(">\n");
        }
    }

    private static void addAssigneeHistories(StringBuilder sb, List<ApprovalCheck.AssigneeHistory> history, Map<String, String> userNamesCache) {
        if (history != null) {
            sb.append("    <").append(ASSIGNEE_HISTORIES_QNAME).append(">\n");
            for (ApprovalCheck.AssigneeHistory historyElement : history) {
                ApprovalChecksConverter.addAssigneeHistory(sb, historyElement, userNamesCache);
            }
            sb.append("    </").append(ASSIGNEE_HISTORIES_QNAME).append(">\n");
        }
    }

    private static void addAssigneeHistory(StringBuilder sb, ApprovalCheck.AssigneeHistory history, Map<String, String> userNamesCache) {
        if (history != null) {
            sb.append("      <").append(ASSIGNEE_HISTORY_QNAME).append(">\n");
            sb.append("    ");
            ApprovalChecksConverter.appendAttribute(sb, AH_DATE_QNAME, TimerUtils.getFormatter().format(history.getDate()));
            sb.append("    ");
            ApprovalChecksConverter.appendAttribute(sb, USER_QNAME, DaoHelper.getUserNameOrKey(history.getAssignee(), userNamesCache));
            sb.append("    ");
            ApprovalChecksConverter.appendAttribute(sb, ROLE_QNAME, history.getRolename());
            sb.append("    ");
            ApprovalChecksConverter.appendAttribute(sb, AH_ASSIGNER_QNAME, DaoHelper.getUserNameOrKey(history.getPerformer(), userNamesCache));
            sb.append("    ");
            ApprovalChecksConverter.appendAttribute(sb, COMMENT_QNAME, history.getComment());
            if (history.getType() != null) {
                sb.append("    ");
                ApprovalChecksConverter.appendAttribute(sb, AH_TYPE_QNAME, history.getType().name());
            }
            sb.append("      </").append(ASSIGNEE_HISTORY_QNAME).append(">\n");
        }
    }

    private static StringBuilder appendAttribute(StringBuilder sb, String qName, String value) {
        sb.append("    <").append(qName).append('>').append(XMLUtils.escape((String)value)).append("</").append(qName).append(">\n");
        return sb;
    }

    private Date getDate(String value) throws ParseException {
        if (!StringUtils.isNotBlank((CharSequence)value)) {
            return null;
        }
        return TimerUtils.parseDate(value);
    }
}

