/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.documentActivity.upgrade.accessor.SpaceUpgradeAccessor;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.SpaceUpgrade;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.Status;
import com.comalatech.confluence.documentActivity.upgrade.service.mapper.SpaceUpgradeMapper;
import com.comalatech.confluence.documentActivity.upgrade.service.mapper.UpgradeTaskMapper;
import com.comalatech.confluence.workflow.accesor.entity.WorkflowActivityRecord;
import com.comalatech.confluence.workflow.analytics.catalog.BandanaKeysCatalog;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class UpgradeStatsGatherer {
    private final SpaceUpgradeAccessor spaceUpgradeAccessor;
    private final SpaceUpgradeMapper spaceUpgradeMapper;
    private final UpgradeTaskMapper upgradeTaskMapper;
    private final SpaceManager spaceManager;
    private final BandanaManager bandanaManager;

    public UpgradeStatsGatherer(@ComponentImport SpaceManager spaceManager, @ComponentImport PageManager pageManager, @ComponentImport LongRunningTaskManager longRunningTaskManager, SpaceUpgradeAccessor spaceUpgradeAccessor, @ComponentImport BandanaManager bandanaManager, @ComponentImport DarkFeatureManager darkFeatureManager) {
        this.spaceManager = spaceManager;
        this.spaceUpgradeAccessor = spaceUpgradeAccessor;
        this.bandanaManager = bandanaManager;
        this.spaceUpgradeMapper = new SpaceUpgradeMapper(spaceManager, pageManager, darkFeatureManager);
        this.upgradeTaskMapper = new UpgradeTaskMapper(longRunningTaskManager);
    }

    public long getTotalDocActivityEntriesAsStatField(List<WorkflowActivityRecord> spaceWorkflowActivities) {
        List<SpaceUpgrade> spaceUpgrades = spaceWorkflowActivities.stream().map(this.spaceUpgradeMapper::fromRecordToModel).collect(Collectors.toList());
        long[] totalDocActivityEntries = new long[]{0L};
        spaceUpgrades.forEach(elem -> {
            Long spaceTotalDocActivityEntries = (Long)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(elem.getSpace()), BandanaKeysCatalog.DOC_ACTIVITY_ENTRIES_COUNTER_KEY);
            if (spaceTotalDocActivityEntries != null) {
                totalDocActivityEntries[0] = totalDocActivityEntries[0] + spaceTotalDocActivityEntries;
            }
        });
        return totalDocActivityEntries[0];
    }

    public long getLatestSpaceUpgraded() {
        Long latestSpaceUpgraded = (Long)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), BandanaKeysCatalog.LATEST_SPACE_UPGRADED_KEY);
        return latestSpaceUpgraded == null ? 0L : latestSpaceUpgraded;
    }

    public long getTotalSpacesUpgraded() {
        Long totalSpacesUpgraded = (Long)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), BandanaKeysCatalog.SPACES_UPGRADED_COUNTER_KEY);
        return totalSpacesUpgraded == null ? 0L : totalSpacesUpgraded;
    }

    public long getTotalSpacesAsStatField() {
        return this.spaceManager.getAllSpaces().size();
    }

    public long getTotalPagesWithHistoryAsStatField(List<WorkflowActivityRecord> spaceWorkflowActivities) {
        return spaceWorkflowActivities.stream().mapToLong(WorkflowActivityRecord::getNumPages).sum();
    }

    public long getTotalSpacesWithHistoryAsStatField(List<WorkflowActivityRecord> spaceWorkflowActivities) {
        return spaceWorkflowActivities.stream().mapToLong(WorkflowActivityRecord::getSpaceId).count();
    }

    public long getHighestNumberPagesWithHistoryPerSpaceAsStatField(List<WorkflowActivityRecord> spaceWorkflowActivities) {
        return spaceWorkflowActivities.stream().mapToLong(WorkflowActivityRecord::getNumPages).max().orElse(0L);
    }

    public double getMedianPagesWithHistoryPerSpaceAsStatField(List<WorkflowActivityRecord> spaceWorkflowActivities) {
        List pagesWithWorkflowPerSpace = spaceWorkflowActivities.stream().map(WorkflowActivityRecord::getNumPages).collect(Collectors.toList());
        return pagesWithWorkflowPerSpace.stream().sorted().skip(Math.max(0, (pagesWithWorkflowPerSpace.size() + 1) / 2 - 1)).limit(1 + (1 + pagesWithWorkflowPerSpace.size()) % 2).mapToLong(Long::intValue).average().orElse(0.0);
    }

    public long getSpaceUpgradesCheckedAsStatField(List<WorkflowActivityRecord> spaceWorkflowActivities) {
        List<SpaceUpgrade> spaceUpgrades = spaceWorkflowActivities.stream().map(this.spaceUpgradeMapper::fromRecordToModel).collect(Collectors.toList());
        spaceUpgrades.forEach(elem -> elem.setUpgradeTask(this.upgradeTaskMapper.fromRecordToModel(this.spaceUpgradeAccessor.getSpaceUpgradeRecord(elem.getSpace()), elem.getSpace())));
        return spaceUpgrades.stream().map(SpaceUpgrade::getUpgradeTask).filter(elem -> elem.getStatus().equals((Object)Status.SUCCESS) || elem.getStatus().equals((Object)Status.FAIL)).count();
    }
}

