/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.workflow.service.WorkflowSearchService;
import java.util.List;

public class CommonAnalyticsManager {
    protected final WorkflowSearchService workflowSearchService;
    protected final SpaceManager spaceManager;

    public CommonAnalyticsManager(WorkflowSearchService workflowSearchService, SpaceManager spaceManager) {
        this.workflowSearchService = workflowSearchService;
        this.spaceManager = spaceManager;
    }

    public long getActivePages() {
        return this.workflowSearchService.getNumberOfPagesWithWorkflow();
    }

    public long getTotalPages() {
        long count = 0L;
        List spaces = this.spaceManager.getAllSpaces();
        for (Space space : spaces) {
            long pages = this.spaceManager.findPageTotal(space);
            count += pages;
        }
        return count;
    }

    public long getActiveSpaces() {
        return this.workflowSearchService.getNumberOfSpacesWithWorkflow();
    }

    public long getTotalSpaces() {
        List spaces = this.spaceManager.getAllSpaces();
        return spaces.size();
    }
}

