/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.accesor;

import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.comalatech.confluence.workflow.accesor.PageWorkflowsAccessor;
import com.comalatech.confluence.workflow.accesor.entity.PageWorkflowsSpaceAdminRecord;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class PageWorkflowsAccessorImpl
implements PageWorkflowsAccessor {
    private final EntityManagerProvider entityManagerProvider;
    private static final int STRING_TYPE_VAL = 5;

    public PageWorkflowsAccessorImpl(EntityManagerProvider entityManagerProvider) {
        this.entityManagerProvider = entityManagerProvider;
    }

    @Override
    @NotNull
    public List<PageWorkflowsSpaceAdminRecord> getPageWorkflowsInSpace(Long spaceId, List<String> pageWorkflowKeys) {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery("SELECT C.id as contentId, C.title as title, OS.type as type, OS.textVal as longWorkflow, OS.stringVal as shortWorkflow FROM ContentEntityObject C, BucketPropertySetItem OS WHERE     C.id = OS.entityId     AND C.space.id = :spaceid     AND OS.key IN (:pageworkflowdbkeys)     AND (OS.stringVal IS NOT NULL OR OS.textVal IS NOT NULL) ", Tuple.class);
        query.setParameter("spaceid", (Object)spaceId);
        query.setParameter("pageworkflowdbkeys", pageWorkflowKeys);
        return query.getResultList().stream().map(record -> this.convertResultToRecord((Long)record.get("contentId"), (String)record.get("title"), (Integer)record.get("type"), (String)record.get("longWorkflow"), (String)record.get("shortWorkflow"))).collect(Collectors.toList());
    }

    private PageWorkflowsSpaceAdminRecord convertResultToRecord(Long contentId, String title, Integer type, String longWorkflow, String shortWorkflow) {
        String workflow = type == 5 ? shortWorkflow : longWorkflow;
        return PageWorkflowsSpaceAdminRecord.builder().contentId(contentId).title(title).workflow(workflow).build();
    }
}

