/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.comalatech.confluence.workflow.ValueReferenceResolver;
import com.comalatech.confluence.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowRenderer {
    private static final Logger log = LoggerFactory.getLogger(WorkflowRenderer.class);
    static final String EMAIL_REGEXP = "[A-Za-z0-9._%-]+@[A-Za-z0-9._-]+\\.[A-Za-z]{2,4}";
    static final String REGEXP = "(\\A|[^@]*[^\\p{Alpha}])(@[\\p{L}\\p{Digit}_>-]+[\\p{L}\\p{Digit} _:\"\\[\\]\\\\,.>-]*@)";
    static final String EMAIL_AT_REPLACEMENT = "ATREPLACEMENT";
    private static final Pattern email_pattern = Pattern.compile("[A-Za-z0-9._%-]+@[A-Za-z0-9._-]+\\.[A-Za-z]{2,4}");
    private static final Pattern pattern = Pattern.compile("(\\A|[^@]*[^\\p{Alpha}])(@[\\p{L}\\p{Digit}_>-]+[\\p{L}\\p{Digit} _:\"\\[\\]\\\\,.>-]*@)");

    public String render(String message, ValueReferenceResolver valueReferenceResolver) throws WorkflowException {
        Matcher email_matcher = email_pattern.matcher(message.replace('\u201d', '\"'));
        ArrayList<String> emailFound = new ArrayList<String>();
        while (email_matcher.find()) {
            emailFound.add(message.substring(email_matcher.start(), email_matcher.end()));
        }
        String[] messageCopy = new String[]{message.replace('\u201d', '\"')};
        emailFound.forEach(email -> {
            String replacement = email.replace("@", EMAIL_AT_REPLACEMENT);
            messageCopy[0] = messageCopy[0].replace((CharSequence)email, replacement);
        });
        Matcher matcher = pattern.matcher(messageCopy[0]);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String resolvedValue;
            matcher.appendReplacement(sb, "");
            sb.append(matcher.group(1));
            String reference = matcher.group(2);
            try {
                resolvedValue = valueReferenceResolver.getValue(reference);
            }
            catch (WorkflowException e) {
                log.error(e.getMessage());
                resolvedValue = reference;
            }
            sb.append(resolvedValue);
        }
        matcher.appendTail(sb);
        return sb.toString().replaceAll(EMAIL_AT_REPLACEMENT, "@");
    }
}

