/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.model.WorkflowConfiguration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfiniteLoopWatchdog {
    private static final Logger log = LoggerFactory.getLogger(InfiniteLoopWatchdog.class);
    private Cache<String, Integer> cache;
    private int thresholdInSeconds;
    private int maxRequests;
    private int maxCount = 0;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final CacheManager cacheManager;

    public InfiniteLoopWatchdog(CacheManager cacheManager, WorkflowConfigurationManager workflowConfigurationManager) {
        this.cacheManager = cacheManager;
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    private Cache<String, Integer> createCache(int _thresholdInSeconds) {
        return this.cacheManager.getCache(InfiniteLoopWatchdog.class.getName() + "_FOR_SECURITY_CONTROL", null, new CacheSettingsBuilder().remote().replicateViaCopy().expireAfterAccess((long)_thresholdInSeconds, TimeUnit.SECONDS).build());
    }

    public boolean hasExceededThreshold(String user, String pageId) {
        int counter;
        this.checkWorkflowConfigurationValues();
        String key = user + ":" + pageId;
        int n = counter = this.cache.get((Object)key) != null ? (Integer)this.cache.get((Object)key) : 0;
        if (++counter > this.maxCount) {
            ++this.maxCount;
            log.info("Max count reached " + this.maxCount + " on key " + key);
        }
        if (counter > this.maxRequests) {
            log.info("Max requests reached " + this.maxRequests + " on key " + key);
            return true;
        }
        this.cache.put((Object)key, (Object)counter);
        return false;
    }

    private void checkWorkflowConfigurationValues() {
        WorkflowConfiguration workflowConfiguration = this.workflowConfigurationManager.getConfiguration();
        int newThreshold = workflowConfiguration.getThresholdInSeconds();
        int newMaxEvents = workflowConfiguration.getMaxEvents();
        if (this.cache == null || this.thresholdInSeconds != newThreshold || this.maxRequests != newMaxEvents) {
            this.cache = this.createCache(newThreshold);
        }
        this.setThresholdInSeconds(newThreshold);
        this.setMaxRequests(newMaxEvents);
    }

    public void setThresholdInSeconds(int thresholdInSeconds) {
        this.thresholdInSeconds = thresholdInSeconds;
    }

    public int getThresholdInSeconds() {
        return this.thresholdInSeconds;
    }

    public void setMaxRequests(int maxRequests) {
        this.maxRequests = maxRequests;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public int getMaxCount() {
        return this.maxCount;
    }
}

