/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.label.LabelAddEvent;
import com.atlassian.confluence.event.events.label.LabelEvent;
import com.atlassian.confluence.event.events.label.LabelRemoveEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityRecord;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.service.ApprovalActivityService;
import com.comalatech.confluence.documentActivity.service.StateActivityService;
import com.comalatech.confluence.documentActivity.service.mapper.ApprovalCheckMapper;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.events.PdfExportErrorEvent;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.events.PdfExportSuccessEvent;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.event.StateEvent;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.PageStateTimer;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.ValueReferenceModifier;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowRenderer;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.events.ApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.InternalApprovalEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentEvent;
import com.comalatech.confluence.workflow.events.WorkflowCustomEvent;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.confluence.workflow.model.ValueReference;
import com.comalatech.workflow.event.AssignmentEvent;
import com.comalatech.workflow.event.TaskEvent;
import com.comalatech.workflow.model.Assignment;
import com.comalatech.workflow.model.SignatureType;
import com.comalatech.workflow.model.Task;
import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValueStore
implements ValueStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultValueStore.class);
    private ConfluenceEvent event;
    private final AbstractPage page;
    private Map<String, String> workflowAttributes = new HashMap<String, String>();
    private PageState pageState;
    private PageWorkflows pageWorkflows;
    private ApprovalCheckMapper approvalCheckMapper;

    public DefaultValueStore(AbstractPage page) {
        this.page = page;
        this.setPageAttributes();
        this.resetPageState();
        this.approvalCheckMapper = new ApprovalCheckMapper(DefaultValueStore.getUserAccessor());
    }

    public DefaultValueStore(ConfluenceEvent event, AbstractPage page) {
        this(page);
        this.event = event;
        this.setEventProperties(event);
        if (this.page == null) {
            throw new RuntimeException("Event " + event + " is not based on a Page CEO");
        }
        this.approvalCheckMapper = new ApprovalCheckMapper(DefaultValueStore.getUserAccessor());
    }

    public DefaultValueStore(AbstractPage page, Map<String, String> attributes, boolean refresh) {
        this.workflowAttributes = new HashMap<String, String>();
        if (!attributes.isEmpty() && refresh) {
            AbstractPage refreshedPage;
            String pageTitle = attributes.get("pagetitle");
            String pageId = attributes.get("pageid");
            if (StringUtils.isBlank((CharSequence)pageTitle) && !StringUtils.isBlank((CharSequence)pageId) && (refreshedPage = DefaultValueStore.getPageManager().getAbstractPage(Long.parseLong(pageId))) != null) {
                attributes.put("pagetitle", refreshedPage.getTitle());
            }
        }
        this.workflowAttributes.putAll(attributes);
        this.page = page;
        this.resetPageState();
        this.approvalCheckMapper = new ApprovalCheckMapper(DefaultValueStore.getUserAccessor());
    }

    public DefaultValueStore(AbstractPage page, ConfluenceEvent event, Map attributes) {
        this(page, attributes, false);
        this.event = event;
        this.setEventProperties(event);
        if (this.page == null) {
            throw new RuntimeException("Event " + event + " is not based on a Page CEO");
        }
        this.approvalCheckMapper = new ApprovalCheckMapper(DefaultValueStore.getUserAccessor());
    }

    @Override
    public boolean canAdminWorkflow(ConfluenceUser user) {
        return DefaultValueStore.getPermissionManager().hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION) || DefaultValueStore.getPermissionManager().hasPermission((User)user, Permission.ADMINISTER, (Object)this.getPage().getSpace()) || this.getPageWorkflows() != null && this.getPageWorkflows().getWorkflowAdminUsers().contains(user.getName());
    }

    private void setEventProperties(ConfluenceEvent event) {
        LabelEvent labelEvent;
        Date eventDate = new Date();
        this.workflowAttributes.put("date", TimerUtils.parseDateWithConfluenceDateFormat(eventDate));
        this.workflowAttributes.put("datetime", TimerUtils.parseDateWithConfluenceDateTimeFormat(eventDate));
        if (event instanceof LabelAddEvent) {
            labelEvent = (LabelEvent)event;
            this.workflowAttributes.put("label", labelEvent.getLabel().getName());
            this.workflowAttributes.put("addedlabel", labelEvent.getLabel().getName());
        } else if (event instanceof LabelRemoveEvent) {
            labelEvent = (LabelEvent)event;
            this.workflowAttributes.put("label", labelEvent.getLabel().getName());
            this.workflowAttributes.put("removedlabel", labelEvent.getLabel().getName());
        } else if (event instanceof InternalApprovalEvent) {
            this.setApprovalAttributes(((InternalApprovalEvent)event).getApprovalCheck());
        } else if (event instanceof WorkflowCustomEvent) {
            WorkflowCustomEvent customEvent = (WorkflowCustomEvent)event;
            this.workflowAttributes.put("errormessage", customEvent.getMessage());
        }
        if (event instanceof StateEvent) {
            PageState state = ((StateEvent)event).getState();
            this.workflowAttributes.put("state", state.getState());
            PageStateTimer dueDate = state.getTimer("Due date");
            if (dueDate != null) {
                this.workflowAttributes.put("expirydate", TimerUtils.parseDateWithConfluenceDateFormat(dueDate.getDueDate()));
                this.workflowAttributes.put("duedate", TimerUtils.parseDateWithConfluenceDateFormat(dueDate.getDueDate()));
            }
            if (state.getComment() != null) {
                this.workflowAttributes.put("comment", state.getComment());
            }
        }
        if (event instanceof TaskEvent) {
            TaskEvent taskEvent = (TaskEvent)event;
            Task task = taskEvent.getTask();
            this.workflowAttributes.put("task", task.getName());
            this.workflowAttributes.put("taskname", task.getName());
            this.workflowAttributes.put("taskcreator", task.getPerformer());
            if (task.getCurrentAssignment() != null) {
                this.workflowAttributes.put("taskassignee", task.getCurrentAssignment().getAssignee());
                this.workflowAttributes.put("taskassigner", task.getCurrentAssignment().getPerformer());
                this.workflowAttributes.put("taskcomment", task.getCurrentAssignment().getComment());
            }
            if (task.getLastCompletion() != null) {
                this.workflowAttributes.put("taskcompleter", task.getLastCompletion().getPerformer());
                this.workflowAttributes.put("taskcomment", task.getLastCompletion().getComment());
            }
            if (task.getDueDate() != null) {
                this.workflowAttributes.put("duedate", TimerUtils.parseDateWithConfluenceDateFormat(task.getDueDate()));
            }
        }
        if (event instanceof AssignmentEvent) {
            AssignmentEvent assignmentEvent = (AssignmentEvent)event;
            String assigneesString = null;
            if (assignmentEvent.getAssignment() != null) {
                assigneesString = assignmentEvent.getAssignment().getAssignee();
            }
            this.workflowAttributes.put("assignee", assigneesString);
            this.workflowAttributes.put("assignees", assigneesString);
            if (assignmentEvent.getAssignment() != null) {
                this.workflowAttributes.put("comment", assignmentEvent.getAssignment().getComment());
                this.workflowAttributes.put("datetime", TimerUtils.parseDateWithConfluenceDateTimeFormat(assignmentEvent.getAssignment().getDate()));
                this.workflowAttributes.put("date", TimerUtils.parseDateWithConfluenceDateFormat(assignmentEvent.getAssignment().getDate()));
            }
        }
        if (event instanceof ApprovalAssignedEvent) {
            this.workflowAttributes.put("comment", ((ApprovalAssignedEvent)event).getComment());
        }
        if (event instanceof PdfExportSuccessEvent) {
            this.workflowAttributes.put("attachmentURL", ((PdfExportSuccessEvent)event).getDownloadUrl(DefaultValueStore.getGlobalSettingsManager().getGlobalSettings().getBaseUrl()));
        }
        if (event instanceof PdfExportErrorEvent) {
            this.workflowAttributes.put("errormessage", ((PdfExportErrorEvent)event).getErrorMessage());
        }
    }

    private void setApprovalAttributes(ApprovalCheck approval) {
        Approver approver = approval.getLastApprover();
        this.workflowAttributes.put("approval", approval.getName());
        this.workflowAttributes.put("approvalname", approval.getName());
        if (approver != null) {
            this.workflowAttributes.put("approvalcomment", approver.getCommentNotNull());
            this.workflowAttributes.put("approvaluser", approver.getUser());
            this.workflowAttributes.put("approvaldate", TimerUtils.parseDateWithConfluenceDateFormat(approver.getDate()));
            SignatureType signature = approver.getSignatureType();
            if (signature != null) {
                this.workflowAttributes.put("signature", String.valueOf(signature.getId()));
            }
        }
        String assignedApprovers = StringUtils.join((Object[])approval.getRequiredApprovers(), (String)", ");
        this.workflowAttributes.put("selectedapprover", assignedApprovers);
        this.workflowAttributes.put("selectedapprovers", assignedApprovers);
        this.workflowAttributes.put("approvalassignees", assignedApprovers);
    }

    private void setPageStateAttributes() {
        if (this.pageState == null) {
            return;
        }
        this.workflowAttributes.put("state", this.pageState.getState());
        Assignment assignment = this.pageState.getLastAssignment();
        if (assignment != null) {
            this.workflowAttributes.put("assignee", ((com.comalatech.confluence.states.model.Assignment)assignment).getAssignee());
        }
    }

    private void setPageAttributes() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String username = user != null ? user.getName() : "";
        String userfullname = user != null ? user.getFullName() : "";
        this.workflowAttributes.put("version", String.valueOf(this.page.getVersion()));
        this.workflowAttributes.put("author", this.page.getCreator() != null ? this.page.getCreator().getName() : null);
        this.workflowAttributes.put("creator", this.page.getCreator() != null ? this.page.getCreator().getName() : null);
        this.workflowAttributes.put("user", username);
        this.workflowAttributes.put("userfullname", userfullname);
        this.workflowAttributes.put("pageid", this.page.getIdAsString());
        this.workflowAttributes.put("pagetitle", this.page.getTitle());
        this.workflowAttributes.put("pagelatest", "[" + this.page.getTitle() + "|" + DefaultValueStore.getGlobalSettingsManager().getGlobalSettings().getBaseUrl() + "/pages/viewpage.action?draft=true&pageId=" + this.page.getIdAsString() + "]");
        String wikiLinkSafeTitle = "";
        if (StringUtils.isNotBlank((CharSequence)this.page.getTitle())) {
            wikiLinkSafeTitle = this.page.getTitle().replace("|", "\u2758").replace("[", "\\[").replace("]", "\\]");
        }
        this.workflowAttributes.put("page", "[" + wikiLinkSafeTitle + "|" + DefaultValueStore.getGlobalSettingsManager().getGlobalSettings().getBaseUrl() + this.page.getUrlPath() + "]");
        this.workflowAttributes.put("pageactivity", "[" + ComalaI18nBean.getComalaI18nBean().getText("approvalsworkflow.page-activity.name") + "|///pages/viewpageactivity.action?pageId=" + this.page.getIdAsString() + "]");
        try {
            Workflow pageWorkflow = this.getAdhocWorkflowManager().getPageWorkflow(this.page);
            if (pageWorkflow != null) {
                this.workflowAttributes.put("pageworkflowname", pageWorkflow.getName());
            }
        }
        catch (WorkflowException e) {
            log.error("Error getting page workflow information from page: " + this.page, (Throwable)e);
        }
    }

    @Override
    public AbstractPage getPage() {
        return this.page;
    }

    @Override
    public PageState getPageState() {
        return this.pageState;
    }

    @Override
    public void resetPageState() {
        this.setPageState(DefaultValueStore.getStateAccessor().getLatestState(this.page));
    }

    @Override
    public void setPageState(PageState pageState) {
        this.pageState = pageState;
        this.setPageStateAttributes();
    }

    @Override
    public ConfluenceEvent getEvent() {
        return this.event;
    }

    @Override
    public AbstractPage getPageByVersion(int version) {
        if (this.page == null) {
            return null;
        }
        return DefaultValueStore.getPageManager().getPageByVersion(this.page, version);
    }

    @Override
    public String getValue(String valueReference) throws WorkflowException {
        String valueName;
        String pageTitle;
        String spaceKey;
        if (!ValueReference.isValueReference(valueReference)) {
            return valueReference;
        }
        ValueReferenceModifier valueReferenceModifier = ValueReferenceModifier.extractValueReferenceModifier(valueReference);
        valueReference = ValueReferenceModifier.removeValueReferenceModifier(valueReference, valueReferenceModifier);
        String value = this.workflowAttributes.get(valueReference = DefaultValueStore.parseValueReferenceIntoName(valueReference));
        if (value != null) {
            return valueReferenceModifier != null ? valueReferenceModifier.modify(value) : value;
        }
        if (this.event instanceof WorkflowAttachmentEvent && (value = this.getAttachmentReference(valueReference)) != null) {
            return value;
        }
        int nameix = valueReference.indexOf(":");
        if (nameix < 0) {
            value = this.getApprovalReferenceValue(valueReference);
            return valueReferenceModifier != null ? valueReferenceModifier.modify(value) : value;
        }
        String supplierValue = this.getWorkflowParameterManager().getSupplierValueAsString(this.page, valueReference);
        if (supplierValue != null) {
            return supplierValue;
        }
        int ix = valueReference.indexOf(58, nameix + 1);
        if (ix < nameix) {
            spaceKey = this.getPage().getSpaceKey();
            pageTitle = valueReference.substring(0, nameix);
            valueName = valueReference.substring(nameix + 1);
        } else {
            spaceKey = valueReference.substring(0, nameix);
            pageTitle = valueReference.substring(nameix + 1, ix);
            valueName = valueReference.substring(ix + 1);
        }
        Page valuePage = DefaultValueStore.getPageManager().getPage(spaceKey, pageTitle);
        if (valuePage == null) {
            return "";
        }
        return this.getParameterValue((AbstractPage)valuePage, valueName);
    }

    public static String parseValueReferenceIntoName(String valueReference) {
        if (valueReference.endsWith("@")) {
            return valueReference.substring(1, valueReference.length() - 1);
        }
        return valueReference.substring(1);
    }

    private String getApprovalReferenceValue(String valueReference) throws WorkflowException {
        String attribute;
        int ix = valueReference.indexOf(">");
        if (ix < 0) {
            return this.getParameterValue(this.getPage(), valueReference);
        }
        String[] references = valueReference.split(">");
        if (references.length != 2) {
            throw new WorkflowUserException("Invalid approval reference " + valueReference);
        }
        String approvalName = references[0].trim();
        switch (attribute = references[1].trim()) {
            case "approvalassignees": 
            case "selected": 
            case "selectedapprover": 
            case "selectedapprovers": {
                return this.getRequiredApprovers(approvalName);
            }
            case "approvaluser": 
            case "user": 
            case "approver": 
            case "approvers": {
                return this.getApproversNames(approvalName);
            }
            case "pendingusers": {
                return this.getPendingUsers(approvalName);
            }
            case "rejector": 
            case "rejectors": {
                return this.getRejectorsNames(approvalName);
            }
            case "approvalcomment": 
            case "comment": {
                return this.getApprovalComment(approvalName);
            }
            case "approvaldate": {
                return this.getApprovalDate(approvalName);
            }
        }
        log.warn("invalid reference " + valueReference + ": invalid attribute");
        return "";
    }

    private String getAttachmentReference(String valueReference) {
        String attribute = valueReference;
        if (valueReference.contains(">")) {
            String[] references = valueReference.split(">");
            if (references.length != 2 || !references[0].trim().equalsIgnoreCase("attachment")) {
                return null;
            }
            attribute = references[1].trim();
        }
        Attachment attachment = ((WorkflowAttachmentEvent)this.event).getAttachment();
        if ("name".equalsIgnoreCase(attribute) || "filename".equalsIgnoreCase(attribute)) {
            return attachment.getFileName();
        }
        if ("comment".equalsIgnoreCase(attribute)) {
            return attachment.getVersionComment();
        }
        if ("type".equalsIgnoreCase(attribute)) {
            return attachment.getType();
        }
        if ("size".equalsIgnoreCase(attribute)) {
            return Long.toString(attachment.getFileSize());
        }
        log.warn("invalid attachment attribute name " + attribute);
        return null;
    }

    @Override
    public String getParameterValue(AbstractPage page, String valueName) {
        AbstractPage latestVersion = page.getLatestVersion();
        return this.getWorkflowParameterManager().getParameterValue(latestVersion, valueName);
    }

    @Override
    public void setMetadataValue(AbstractPage page, String valueName, String value) {
        String wiki = "{metadata:" + valueName + "|hidden=true}" + value + "{metadata}";
        DefaultValueStore.getWikiStyleRenderer().convertWikiToXHtml((RenderContext)page.toPageContext(), wiki);
    }

    @Override
    public String replaceReferences(String message) {
        try {
            return new WorkflowRenderer().render(message, this);
        }
        catch (WorkflowException e) {
            log.error("error replacing references " + e.getMessage());
            return message;
        }
    }

    @Override
    public Set<String> getInvolvedUsersNames() {
        HashSet<String> users = new HashSet<String>();
        users.add(this.page.getCreator() != null ? this.page.getCreator().getName() : null);
        users.add(this.page.getLastModifier() != null ? this.page.getLastModifier().getName() : null);
        return users;
    }

    @Override
    public void setProperty(String propertyName, String value) {
        this.workflowAttributes.put(propertyName, value);
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.setProperty("errormessage", errorMessage);
    }

    @Override
    public void putProperties(Map properties) {
        this.workflowAttributes.putAll(properties);
    }

    @Override
    public Map getPropertiesMap() {
        return this.workflowAttributes;
    }

    @Override
    public PageWorkflows getPageWorkflows() {
        return this.pageWorkflows;
    }

    @Override
    public void setPageWorkflows(PageWorkflows pageWorkflows) {
        this.pageWorkflows = pageWorkflows;
    }

    private static WikiStyleRenderer getWikiStyleRenderer() {
        return (WikiStyleRenderer)ComponentLocator.getComponent(WikiStyleRenderer.class);
    }

    private static PageManager getPageManager() {
        return (PageManager)ComponentLocator.getComponent(PageManager.class);
    }

    private static StateAccessor getStateAccessor() {
        return PluginContainerManager.getComponent(StateAccessor.class);
    }

    private static UserAccessor getUserAccessor() {
        return PluginContainerManager.getComponent(UserAccessor.class);
    }

    private static ApprovalAccessor getApprovalAccessor() {
        return PluginContainerManager.getComponent(ApprovalAccessor.class);
    }

    private InternalWorkflowParameterManager getWorkflowParameterManager() {
        return PluginContainerManager.getComponent(InternalWorkflowParameterManager.class);
    }

    private StateActivityService getStateActivityService() {
        return PluginContainerManager.getComponent(StateActivityService.class);
    }

    private ApprovalActivityService getApprovalActivityService() {
        return PluginContainerManager.getComponent(ApprovalActivityService.class);
    }

    private DocumentActivityUpgradeService getDocumentActivityUpgradeService() {
        return PluginContainerManager.getComponent(DocumentActivityUpgradeService.class);
    }

    private DarkFeatureManager getDarkFeatureManager() {
        return PluginContainerManager.getComponent(DarkFeatureManager.class);
    }

    @Override
    public boolean isAdminOverride() {
        if (ActionContext.getContext() == null || ActionContext.getContext().getContextMap() == null) {
            return false;
        }
        HttpParameters contextParams = ActionContext.getContext().getParameters();
        if (contextParams == null) {
            return false;
        }
        Parameter adminParam = (Parameter)contextParams.get("admin");
        if (adminParam == null || adminParam.getValue() == null) {
            return false;
        }
        if (!"true".equals(adminParam.getValue())) {
            return false;
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.canAdminWorkflow(user);
    }

    public static PermissionManager getPermissionManager() {
        return (PermissionManager)ComponentLocator.getComponent(PermissionManager.class);
    }

    public static GlobalSettingsManager getGlobalSettingsManager() {
        return (GlobalSettingsManager)ComponentLocator.getComponent(GlobalSettingsManager.class);
    }

    public AdhocWorkflowManager getAdhocWorkflowManager() {
        return PluginContainerManager.getComponent(AdhocWorkflowManager.class);
    }

    private String getRequiredApprovers(String approvalName) {
        ApprovalCheck approvalCheck = this.getApprovalCheck(approvalName);
        if (approvalCheck == null) {
            log.info("Approval check does not exist");
            return "";
        }
        return MiscUtils.listToString(approvalCheck.getRequiredApprovers());
    }

    private String getApproversNames(String approvalName) {
        ApprovalCheck approvalCheck = this.getApprovalCheck(approvalName);
        if (approvalCheck == null) {
            log.info("Approval check does not exist");
            return "";
        }
        return approvalCheck.getApproversNames();
    }

    private String getRejectorsNames(String approvalName) {
        ApprovalCheck approvalCheck = this.getApprovalCheck(approvalName);
        if (approvalCheck == null) {
            log.info("Approval check does not exist");
            return "";
        }
        return approvalCheck.getRejectorsNames();
    }

    private String getPendingUsers(String approvalName) {
        ApprovalCheck approvalCheck = DefaultValueStore.getApprovalAccessor().getLatestApprovalCheckInCurrentState(this.page, approvalName);
        String stateName = null;
        if (approvalCheck == null) {
            log.error("Approval check does not exist for current state, pending users value reference cannot be resolved");
            return "";
        }
        if (this.getDocumentActivityUpgradeService().hasAlreadyBeenUpgraded(this.page) && !this.getDarkFeatureManager().isEnabledForAllUsers("comalatech.workflows.oracledb.oldactivity.enabled").orElse(true).booleanValue()) {
            BaseActivityRecord state = this.getStateActivityService().getByState(this.page.getId(), Long.valueOf(approvalCheck.getStateId())).stream().findFirst().orElse(null);
            stateName = state != null ? state.getStateName() : "";
        } else {
            PageState state = DefaultValueStore.getStateAccessor().getState(this.page, approvalCheck.getStateId());
            if (state != null) {
                stateName = state.getState();
            }
        }
        if (approvalCheck.getStateId() != this.pageState.getId() && stateName != null && stateName.equals(this.pageState.getState())) {
            approvalCheck = null;
        }
        if (approvalCheck == null) {
            log.info("Approval check does not exist");
            return "";
        }
        return MiscUtils.listToString(approvalCheck.getPendingApproversArray(false));
    }

    private String getApprovalComment(String approvalName) {
        ApprovalCheck approvalCheck = this.getApprovalCheck(approvalName);
        if (approvalCheck == null) {
            log.info("Approval check does not exist");
            return "";
        }
        if (approvalCheck.getLastApprover() != null) {
            return approvalCheck.getLastApprover().getCommentNotNull();
        }
        return "";
    }

    private String getApprovalDate(String approvalName) {
        ApprovalCheck approvalCheck = this.getApprovalCheck(approvalName);
        if (approvalCheck == null) {
            log.info("Approval check does not exist");
            return "";
        }
        if (approvalCheck.getLastApprover() != null) {
            return TimerUtils.parseDateWithConfluenceDateFormat(approvalCheck.getLastApprover().getDate());
        }
        return "";
    }

    private ApprovalCheck getApprovalCheck(String approvalName) {
        ApprovalCheck approvalCheck = DefaultValueStore.getApprovalAccessor().getLatestApprovalCheckInCurrentState(this.page, approvalName);
        String stateName = null;
        if (approvalCheck == null) {
            if (this.getDocumentActivityUpgradeService().hasAlreadyBeenUpgraded(this.page) && !this.getDarkFeatureManager().isEnabledForAllUsers("comalatech.workflows.oracledb.oldactivity.enabled").orElse(true).booleanValue()) {
                approvalCheck = this.getLastApprovalInstance(this.page.getId(), approvalName);
                if (approvalCheck != null) {
                    BaseActivityRecord state = this.getStateActivityService().getByState(this.page.getId(), Long.valueOf(approvalCheck.getStateId())).stream().findFirst().orElse(null);
                    stateName = state != null ? state.getStateName() : "";
                }
            } else {
                PageState state;
                approvalCheck = DefaultValueStore.getApprovalAccessor().getLatestApprovalCheck(this.page, null, approvalName, 0);
                if (approvalCheck != null && (state = DefaultValueStore.getStateAccessor().getState(this.page, approvalCheck.getStateId())) != null) {
                    stateName = state.getState();
                }
            }
        }
        if (approvalCheck != null && approvalCheck.getStateId() != this.pageState.getId() && stateName != null && stateName.equals(this.pageState.getState())) {
            approvalCheck = null;
        }
        return approvalCheck;
    }

    private ApprovalCheck getLastApprovalInstance(Long contentId, String approvalName) {
        State state;
        PageState pageState = this.getPageState();
        PageWorkflows pageWorkflows = this.getPageWorkflows();
        if (pageWorkflows == null) {
            log.error("pageWorkflows object is null. Unable to retrieve the state");
        }
        if (pageState != null && pageWorkflows != null && (state = pageWorkflows.getStatesContainer().getState(pageState.getName())) != null && state.getApprovals().stream().anyMatch(approval -> approvalName.equals(approval.getName()))) {
            return null;
        }
        ArrayList<Activity> result = new ArrayList<Activity>();
        result.add(this.getApprovalActivityService().getLatestFullyApproved(contentId, approvalName));
        result.add(this.getApprovalActivityService().getLatestFullyRejected(contentId, approvalName));
        Activity latestApproval = result.stream().filter(Objects::nonNull).sorted((a1, a2) -> Long.compare(a2.getMoment(), a1.getMoment())).findFirst().orElse(null);
        return this.approvalCheckMapper.toApprovalCheck(latestApproval);
    }
}

