/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.translator.domain;

import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.translator.domain.ServerWorkflow;
import com.comalatech.confluence.translator.domain.TriggerMacro;
import com.comalatech.confluence.util.PluginContainerManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class ActionMapper {
    private static final String CLOUD_SET_MESSAGE_INFO_TYPE = "info";
    private static final String CLOUD_SET_MESSAGE_WARNING_TYPE = "warning";
    private static final String CLOUD_SET_MESSAGE_ERROR_TYPE = "error";
    private static final String SERVER_SET_MESSAGE_INFO_TYPE = "info";
    private static final String SERVER_SET_MESSAGE_WARNING_TYPE = "warning";
    private static final String SERVER_SET_MESSAGE_ERROR_TYPE = "error";
    private static final String SERVER_SET_MESSAGE_SUCCESS_TYPE = "success";
    private static final String ACTION = "action";
    private static final String GROUP = "group";
    private static final String USER = "user";
    private static final String TYPE = "type";

    public static Map<String, Object> getChangeStateAction(TriggerMacro triggerMacro, boolean isParsingMacro) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        if (isParsingMacro) {
            action.put(ACTION, ServerWorkflow.CLOUD_TRIGGER_SUPPORTED_ACTIONS.get(triggerMacro.getName()));
            action.put("state", triggerMacro.getParameters().stream().filter(parameter -> !parameter.contains(":")).filter(parameter -> !parameter.contains("=")).findFirst().orElse(null));
        } else {
            List<String> unsupportedParams = ActionMapper.getUnsupportedParams(triggerMacro);
            if (unsupportedParams.isEmpty()) {
                return Collections.emptyMap();
            }
            action.put(triggerMacro.getName(), unsupportedParams);
        }
        return action;
    }

    public static Map<String, Object> getApprovalAction(TriggerMacro triggerMacro, boolean isParsingMacro) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        if (isParsingMacro) {
            action.put(ACTION, triggerMacro.getName().equals("approve-page") ? ServerWorkflow.CLOUD_TRIGGER_SUPPORTED_ACTIONS.get("approve-page") : ServerWorkflow.CLOUD_TRIGGER_SUPPORTED_ACTIONS.get("reject-page"));
            triggerMacro.getParameters().stream().filter(parameter -> !parameter.contains(":")).filter(parameter -> !parameter.contains("=")).findFirst().ifPresent(approvalName -> action.put("approval", approvalName));
            action.put(USER, "<AtlassianUserID>");
        } else {
            List<String> unsupportedParams = ActionMapper.getUnsupportedParams(triggerMacro);
            if (unsupportedParams.isEmpty()) {
                return Collections.emptyMap();
            }
            action.put(triggerMacro.getName(), unsupportedParams);
        }
        return action;
    }

    private static List<String> getUnsupportedParams(TriggerMacro triggerMacro) {
        return triggerMacro.getParameters().stream().filter(parameter -> parameter.contains("=")).map(parameter -> parameter.split("=")[0]).collect(Collectors.toList());
    }

    public static Map<String, Object> getExpirationAction(TriggerMacro triggerMacro, boolean isParsingMacro) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        if (isParsingMacro) {
            action.put(ACTION, ServerWorkflow.CLOUD_TRIGGER_SUPPORTED_ACTIONS.get(triggerMacro.getName()));
            String dueDate = triggerMacro.getParameters().stream().filter(parameter -> parameter.contains("duedate")).filter(parameter -> parameter.contains("=")).findFirst().orElse(null);
            if (dueDate != null) {
                dueDate = dueDate.split("=")[1];
                action.put("dueDate", dueDate);
            }
            return action;
        }
        return Collections.emptyMap();
    }

    public static Map<String, Object> getSetMessageAction(TriggerMacro triggerMacro, boolean isParsingMacro) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        if (isParsingMacro) {
            String macroBody = triggerMacro.getBody();
            String macroName = triggerMacro.getName();
            if (StringUtils.isBlank((CharSequence)macroBody)) {
                action.put(ACTION, "clean-messages");
            } else {
                action.put(ACTION, ServerWorkflow.CLOUD_TRIGGER_SUPPORTED_ACTIONS.get(macroName));
                if (triggerMacro.getParameters() != null) {
                    String type = triggerMacro.getParameters().stream().filter(param -> param.contains("info") || param.contains(SERVER_SET_MESSAGE_SUCCESS_TYPE) || param.contains("warning") || param.contains("error")).map(param -> {
                        if (param.contains("info") || param.contains(SERVER_SET_MESSAGE_SUCCESS_TYPE)) {
                            return "info";
                        }
                        if (param.contains("warning")) {
                            return "warning";
                        }
                        if (param.contains("error")) {
                            return "error";
                        }
                        return "";
                    }).findFirst().orElse("info");
                    action.put(TYPE, type);
                } else {
                    action.put(TYPE, "info");
                }
                action.put("body", macroBody);
            }
        } else {
            List unsupportedParams = triggerMacro.getParameters().stream().filter(parameter -> !parameter.contains("style")).collect(Collectors.toList());
            List trimmedParameters = unsupportedParams.stream().map(ActionMapper::getString).collect(Collectors.toList());
            if (unsupportedParams.isEmpty()) {
                return Collections.emptyMap();
            }
            action.put(triggerMacro.getName(), trimmedParameters);
        }
        return action;
    }

    public static Map<String, Object> getSendEmailAction(TriggerMacro triggerMacro, boolean isParsingMacro) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        if (isParsingMacro) {
            String address;
            action.put(ACTION, ServerWorkflow.CLOUD_TRIGGER_SUPPORTED_ACTIONS.get(triggerMacro.getName()));
            ArrayList recipients = new ArrayList();
            String users = triggerMacro.getParameters().stream().filter(parameter -> parameter.contains(USER)).findFirst().orElse(null);
            if (users != null) {
                users = users.split("=")[1];
                List<String> usersList = Arrays.asList(users.split(","));
                usersList.stream().map(String::trim).forEach(name -> {
                    if (!ActionMapper.getUserAccessor().getGroupsByGroupNames(Collections.singletonList(name)).isEmpty()) {
                        recipients.add(Map.of(GROUP, name));
                    } else if (name.contains("@")) {
                        recipients.add(name);
                    } else {
                        recipients.add(Map.of(USER, name));
                    }
                });
            }
            if ((address = (String)triggerMacro.getParameters().stream().filter(parameter -> parameter.contains("address")).findFirst().orElse(null)) != null) {
                address = address.split("=")[1];
                List addressList = Arrays.stream(address.split(",")).map(String::trim).collect(Collectors.toList());
                recipients.addAll(addressList);
            }
            action.put("recipients", recipients);
            String subject = triggerMacro.getParameters().stream().filter(parameter -> parameter.contains("subject")).findFirst().orElse(null);
            if (subject != null) {
                subject = subject.split("=")[1];
            }
            HashMap<String, String> notification = new HashMap<String, String>();
            notification.put("subject", subject);
            notification.put("body", triggerMacro.getBody());
            action.put("notification", notification);
        } else {
            List<String> supportedParams = List.of("subject", USER, "address");
            List unsupportedParams = triggerMacro.getParameters().stream().filter(parameter -> !supportedParams.contains(parameter.split("=")[0])).collect(Collectors.toList());
            List trimmedParameters = unsupportedParams.stream().map(ActionMapper::getString).collect(Collectors.toList());
            if (unsupportedParams.isEmpty()) {
                return Collections.emptyMap();
            }
            action.put(triggerMacro.getName(), trimmedParameters);
        }
        return action;
    }

    public static Map<String, Object> getGenericAction(TriggerMacro triggerMacro, boolean isParsingMacro) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        if (isParsingMacro) {
            action.put(ACTION, ServerWorkflow.CLOUD_TRIGGER_SUPPORTED_ACTIONS.get(triggerMacro.getName()));
        } else {
            if (triggerMacro.getParameters().isEmpty()) {
                return Collections.emptyMap();
            }
            action.put(triggerMacro.getName(), triggerMacro.getParameters().stream().map(parameter -> parameter.contains("=") ? parameter.split("=")[0] : parameter).collect(Collectors.toList()));
        }
        return action;
    }

    public static Map<String, Object> getLabelsAction(TriggerMacro triggerMacro, boolean isParsingMacro) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        if (isParsingMacro) {
            action.put(ACTION, ServerWorkflow.CLOUD_TRIGGER_SUPPORTED_ACTIONS.get(triggerMacro.getName()));
            action.put("labels", Collections.singletonList(triggerMacro.getParameters().stream().filter(parameter -> !parameter.contains(":")).filter(parameter -> !parameter.contains("=")).findFirst().orElse(null)));
            if (triggerMacro.getParameters().contains("children=true")) {
                action.put("children", true);
            }
        } else {
            List unsupportedParams = triggerMacro.getParameters().stream().filter(parameter -> !parameter.contains("children")).filter(parameter -> parameter.contains("=")).map(parameter -> parameter.split("=")[0]).collect(Collectors.toList());
            if (unsupportedParams.isEmpty()) {
                return Collections.emptyMap();
            }
            action.put(triggerMacro.getName(), unsupportedParams);
        }
        return action;
    }

    public static Map<String, Object> getRestrictionsAction(TriggerMacro triggerMacro, boolean isParsingMacro) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        if (isParsingMacro) {
            action.put(ACTION, ServerWorkflow.CLOUD_TRIGGER_SUPPORTED_ACTIONS.get(triggerMacro.getName()));
            action.put(TYPE, triggerMacro.getParameters().stream().filter(t -> t.contains(TYPE)).map(parameter -> parameter.split("=")[1]).findFirst().orElse(null));
            LinkedHashMap userList = new LinkedHashMap();
            LinkedHashMap groupList = new LinkedHashMap();
            triggerMacro.getParameters().stream().filter(t -> t.contains(USER) || t.contains(GROUP)).forEach(parameter -> {
                String[] splitParameter = parameter.split("=");
                String[] values = splitParameter[1].split(",");
                if (splitParameter[0].contains(USER)) {
                    userList.put(USER, values);
                }
                if (splitParameter[0].contains(GROUP)) {
                    groupList.put(GROUP, values);
                }
            });
            ArrayList combinedList = new ArrayList();
            if (!userList.isEmpty()) {
                combinedList.add(userList);
            }
            if (!groupList.isEmpty()) {
                combinedList.add(groupList);
            }
            action.put("restrictions", new ArrayList(combinedList));
            return action;
        }
        List<String> supportedParams = List.of(TYPE, USER, GROUP);
        List unsupportedParams = triggerMacro.getParameters().stream().filter(parameter -> !supportedParams.contains(parameter.split("=")[0])).collect(Collectors.toList());
        if (unsupportedParams.isEmpty()) {
            return Collections.emptyMap();
        }
        List trimmedParameters = unsupportedParams.stream().map(ActionMapper::getString).collect(Collectors.toList());
        action.put(triggerMacro.getName(), trimmedParameters);
        return action;
    }

    private static String getString(String parameter) {
        if (parameter.contains("=")) {
            return parameter.split("=")[0];
        }
        if (parameter.contains(":")) {
            return parameter.split(":")[0];
        }
        return parameter;
    }

    private static UserAccessor getUserAccessor() {
        return PluginContainerManager.getComponent(UserAccessor.class);
    }
}

