/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.service;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.contributors.ContributorsManager;
import com.comalatech.confluence.dataextractor.DataExtractorManager;
import com.comalatech.confluence.documentActivity.service.DocumentActivityService;
import com.comalatech.confluence.messaging.PageMessageManager;
import com.comalatech.confluence.readack.activity.ReadAckActivityManager;
import com.comalatech.confluence.readack.service.ReadAckConfigManager;
import com.comalatech.confluence.readack.service.ReadAckManager;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.ApprovalRolesManager;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflowreports.ActivityManager;
import com.comalatech.workflow.model.WorkflowParameter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ClearWorkflowHistoryService {
    private static final Logger log = LoggerFactory.getLogger(ClearWorkflowHistoryService.class);
    private final StateAccessor stateAccessor;
    private final ApprovalAccessor approvalAccessor;
    private final AdhocWorkflowManager adhocWorkflowManager;
    private final ActivityManager activityManager;
    private final DataExtractorManager dataExtractorManager;
    private final ReadAckConfigManager readAckConfigManager;
    private final ReadAckManager readAckManager;
    private final ContributorsManager contributorsManager;
    private final ReadAckActivityManager readAckActivityManager;
    private final PageMessageManager pageMessageManager;
    private final InternalWorkflowParameterManager workflowParameterManager;
    private final ApprovalRolesManager approvalRolesManager;
    private final DarkFeatureManager darkFeatureManager;
    private final DocumentActivityService documentActivityService;

    public ClearWorkflowHistoryService(StateAccessor stateAccessor, ApprovalAccessor approvalAccessor, AdhocWorkflowManager adhocWorkflowManager, ActivityManager activityManager, DataExtractorManager dataExtractorManager, ReadAckConfigManager readAckConfigManager, ReadAckManager readAckManager, ReadAckActivityManager readAckActivityManager, ContributorsManager contributorsManager, PageMessageManager pageMessageManager, InternalWorkflowParameterManager workflowParameterManager, ApprovalRolesManager approvalRolesManager, @ComponentImport DarkFeatureManager darkFeatureManager, DocumentActivityService documentActivityService) {
        this.stateAccessor = stateAccessor;
        this.approvalAccessor = approvalAccessor;
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.activityManager = activityManager;
        this.dataExtractorManager = dataExtractorManager;
        this.readAckConfigManager = readAckConfigManager;
        this.readAckActivityManager = readAckActivityManager;
        this.readAckManager = readAckManager;
        this.contributorsManager = contributorsManager;
        this.pageMessageManager = pageMessageManager;
        this.workflowParameterManager = workflowParameterManager;
        this.approvalRolesManager = approvalRolesManager;
        this.darkFeatureManager = darkFeatureManager;
        this.documentActivityService = documentActivityService;
    }

    public boolean clearSpaceRolesHistory(String spaceKey) {
        this.approvalRolesManager.removeApprovalRoles(spaceKey);
        return true;
    }

    public boolean clearPageWorkflowHistory(AbstractPage page, boolean removeData, boolean removeMetadata) throws WorkflowException {
        if (removeMetadata) {
            Workflow pageWorkflow = this.adhocWorkflowManager.getPageWorkflow(page);
            for (WorkflowParameter param : pageWorkflow.getWorkflowParameters()) {
                this.workflowParameterManager.cleanPageWorkflowParameterValue(page, param);
            }
        }
        this.adhocWorkflowManager.removeWorkflow(page);
        if (removeData) {
            this.stateAccessor.removeStates(page);
            this.approvalAccessor.removeApprovalChecks(page);
            this.contributorsManager.deleteContributors(page);
            this.readAckManager.removeReadAckUserRecords(page);
            this.readAckConfigManager.removeReadAckConfig(page);
            this.readAckActivityManager.removeReadAckActivities(page);
            this.activityManager.clearRecentActivityDateCache((ContentEntityObject)page);
            this.pageMessageManager.removePageMessages(page);
            if (!this.darkFeatureManager.isEnabledForAllUsers("comalatech.workflows.newactivity.listener.disabled").orElse(true).booleanValue()) {
                this.documentActivityService.delete(page.getId());
            }
            return this.dataExtractorManager.clearAllContentProperties((EntityObject)page);
        }
        return true;
    }

    public void clearUserMessages(List<String> pageIds) {
        if (this.darkFeatureManager.isFeatureEnabledForAllUsers("comalatech.workflows.clear.page.user.messages")) {
            log.debug("Dark feature {} is enabled. Clearing user messages for pages {}", (Object)"comalatech.workflows.clear.page.user.messages", pageIds);
            this.pageMessageManager.removeUserMessages(pageIds);
        }
    }
}

