/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.resources;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.user.User;
import com.comalatech.confluence.adhocworkflows.rest.permissions.EditPagePermissionRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.ViewPagePermissionRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.ViewWorkflowPermissionRequired;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.readack.ReadAckException;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.confluence.workflow.restv2.resources.AbstractRestResource;
import javax.ws.rs.core.Response;

public abstract class AbstractRestReadAckResource
extends AbstractRestResource {
    protected final WorkflowPermissionManager workflowPermissionManager;

    public AbstractRestReadAckResource() {
        this.workflowPermissionManager = PluginContainerManager.getComponent(WorkflowPermissionManager.class);
    }

    public AbstractRestReadAckResource(PermissionManager permissionManager, SpaceManager spaceManager, PageManager pageManager, WorkflowMarkupManager workflowMarkupManager, WorkflowsFeatureManager workflowsFeatureManager, WorkflowPermissionManager workflowPermissionManager, ComalaI18nBean comalaI18nBean) {
        super(permissionManager, spaceManager, pageManager, workflowMarkupManager, workflowsFeatureManager, comalaI18nBean);
        this.workflowPermissionManager = workflowPermissionManager;
    }

    public abstract class RestReadAckCommand
    extends AbstractRestResource.RestPageCommand {
        protected boolean canViewWorkflows;
        protected AbstractPage page;

        public RestReadAckCommand(long contentId) {
            super(contentId);
        }

        @Override
        public abstract Response doExecute() throws ReadAckException;

        @Override
        protected AbstractRestResource.RestCommand validate() throws ApplicationPermissionException {
            super.validate();
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            this.page = (AbstractPage)this.getValidationTarget();
            this.canViewWorkflows = AbstractRestReadAckResource.this.workflowPermissionManager.canViewWorkflows(this.page.getSpace(), user);
            if (!AbstractRestReadAckResource.this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)this.page) && (this.hasAnnotation(ViewPagePermissionRequired.class) || this.hasAnnotation(EditPagePermissionRequired.class) || this.hasAnnotation(ViewWorkflowPermissionRequired.class))) {
                String message = AbstractRestReadAckResource.this.comalaI18nBean.getText("readack.permission.error.view");
                throw new ApplicationPermissionException(message);
            }
            if (this.hasAnnotation(EditPagePermissionRequired.class) && !AbstractRestReadAckResource.this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)this.page)) {
                String message = AbstractRestReadAckResource.this.comalaI18nBean.getText("readack.permission.error.edit");
                throw new ApplicationPermissionException(message);
            }
            if (this.hasAnnotation(ViewWorkflowPermissionRequired.class) && !this.canViewWorkflows) {
                String message = AbstractRestReadAckResource.this.comalaI18nBean.getText("readack.permission.error.workflow.view");
                throw new ApplicationPermissionException(message);
            }
            return this;
        }
    }
}

