/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.service;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.PdfExportServiceAccessor;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.PdfExportServiceHolder;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.mapper.PdfExportMapper;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.model.PdfExportActionModel;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.model.PdfExportResultModel;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.service.PdfExporterService;
import com.k15t.scroll.exporter.api.pdf.PdfExportRequest;
import com.k15t.scroll.exporter.api.pdf.PdfExportResult;
import com.k15t.scroll.exporter.api.pdf.PdfExportService;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultPdfExporterService
implements PdfExporterService {
    private static final Logger log = LoggerFactory.getLogger(DefaultPdfExporterService.class);
    private final PdfExportServiceAccessor pdfExportServiceAccessor;
    private final PermissionManager permissionManager;

    public DefaultPdfExporterService(PdfExportServiceAccessor pdfExportServiceAccessor, @ComponentImport PermissionManager permissionManager) {
        this.pdfExportServiceAccessor = pdfExportServiceAccessor;
        this.permissionManager = permissionManager;
    }

    @Override
    public PdfExportResultModel generatePdfOfAbstractPage(AbstractPage abstractPage) throws IOException {
        return this.generatePdfOfAbstractPage(abstractPage, "current");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PdfExportResultModel generatePdfOfAbstractPage(AbstractPage abstractPage, String exportScope) throws IOException {
        if (abstractPage == null) {
            log.error("Null abstract page found on pdf generation request");
            return null;
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission((User)currentUser, Permission.VIEW, (Object)abstractPage)) {
            if (this.permissionManager.hasPermission((User)abstractPage.getLastModifier(), Permission.VIEW, (Object)abstractPage)) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Current user '" + currentUser + "' has no edit permissions over '" + abstractPage + "'. The last modifier of the page ('" + abstractPage.getLastModifier() + "') will be temporarily authenticated to create a pfd with Scroll PDF Exporter");
                    }
                    AuthenticatedUserThreadLocal.set((ConfluenceUser)abstractPage.getLastModifier());
                    PdfExportResultModel pdfExportResultModel = this.generatePdfOfAbstractPageWithoutCheckingPermissions(abstractPage, exportScope);
                    return pdfExportResultModel;
                }
                finally {
                    AuthenticatedUserThreadLocal.set((ConfluenceUser)currentUser);
                }
            }
            if (log.isInfoEnabled()) {
                log.info("PDF cannot be created in " + abstractPage + " with Scroll PDF Exporter because its last modifier ('" + abstractPage.getLastModifier() + "') has no edit permissions over it.");
            }
            return null;
        }
        return this.generatePdfOfAbstractPageWithoutCheckingPermissions(abstractPage, exportScope);
    }

    @Override
    public PdfExportResultModel generatePdfOfAbstractPage(AbstractPage abstractPage, PdfExportActionModel model) throws IOException {
        return this.generatePdfOfAbstractPage(abstractPage, model, "current");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdfExportResultModel generatePdfOfAbstractPage(AbstractPage abstractPage, PdfExportActionModel model, String exportScope) throws IOException {
        if (abstractPage == null) {
            log.error("Null abstract page found on pdf generation request");
            return null;
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission((User)currentUser, Permission.VIEW, (Object)abstractPage)) {
            if (this.permissionManager.hasPermission((User)abstractPage.getLastModifier(), Permission.VIEW, (Object)abstractPage)) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Current user '" + currentUser + "' has no edit permissions over '" + abstractPage + "'. The last modifier of the page ('" + abstractPage.getLastModifier() + "') will be temporarily authenticated to create a pfd with Scroll PDF Exporter");
                    }
                    AuthenticatedUserThreadLocal.set((ConfluenceUser)abstractPage.getLastModifier());
                    PdfExportResultModel pdfExportResultModel = this.generatePdfOfAbstractPageWithoutCheckingPermissions(abstractPage, model, exportScope);
                    return pdfExportResultModel;
                }
                finally {
                    AuthenticatedUserThreadLocal.set((ConfluenceUser)currentUser);
                }
            }
            if (log.isInfoEnabled()) {
                log.info("PDF cannot be created in " + abstractPage + " with Scroll PDF Exporter because its last modifier ('" + abstractPage.getLastModifier() + "') has no edit permissions over it.");
            }
            return null;
        }
        return this.generatePdfOfAbstractPageWithoutCheckingPermissions(abstractPage, model, exportScope);
    }

    private PdfExportResultModel generatePdfOfAbstractPageWithoutCheckingPermissions(AbstractPage abstractPage, String exportScope) throws IOException {
        PdfExportService pdfExportService = (PdfExportService)this.getPdfExportService().getPdfExportService();
        PdfExportRequest exportRequest = pdfExportService.createExportRequest(abstractPage.getId()).withExportScope(exportScope);
        PdfExportResult exportResult = pdfExportService.export(exportRequest);
        return PdfExportMapper.exportRecordToModel(exportResult);
    }

    private PdfExportResultModel generatePdfOfAbstractPageWithoutCheckingPermissions(AbstractPage abstractPage, PdfExportActionModel model, String exportScope) throws IOException {
        PdfExportService pdfExportService = (PdfExportService)this.getPdfExportService().getPdfExportService();
        PdfExportRequest exportRequest = pdfExportService.createExportRequest(abstractPage.getId()).withExportScope(exportScope).withTemplateId(model.getTemplateId());
        PdfExportResult exportResult = pdfExportService.export(exportRequest);
        return PdfExportMapper.exportRecordToModel(exportResult);
    }

    private PdfExportServiceHolder getPdfExportService() {
        return this.pdfExportServiceAccessor.getPdfExportServiceHolder();
    }
}

