/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.util.pagination.PaginationSupport;
import com.servicerocket.confluence.randombits.filtering.core.criteria.Criteria;
import com.servicerocket.confluence.randombits.filtering.core.criteria.Criterion;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.customware.reporting.core.query.AbstractQuery;
import net.customware.reporting.core.query.Query;
import net.customware.reporting.core.query.QueryException;
import org.randombits.confluence.support.MacroInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowReporterMacroDelegate {
    private static final Logger log = LoggerFactory.getLogger(WorkflowReporterMacroDelegate.class);
    private final Object workflowReportManager;

    public WorkflowReporterMacroDelegate(Object workflowReportManager) {
        this.workflowReportManager = workflowReportManager;
    }

    public Query createQuery(MacroInfo macroInfo) throws QueryException {
        return new WorkflowQuery(macroInfo);
    }

    class WorkflowQuery
    extends AbstractQuery<AbstractPage> {
        MacroInfo macroInfo;

        public WorkflowQuery(MacroInfo macroInfo) throws QueryException {
            super(false);
            this.macroInfo = macroInfo;
        }

        public Class<AbstractPage> getValueType() {
            return AbstractPage.class;
        }

        private List<ContentEntityObject> findContent(MacroInfo macroInfo) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            ArrayList<ContentEntityObject> pages = new ArrayList<ContentEntityObject>();
            ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
            Class<?> workflowReportManagerClass = cl.loadClass("com.comalatech.confluence.workflowreports.WorkflowReportManager");
            Class<?> workflowReportOptionsClass = cl.loadClass("com.comalatech.confluence.workflowreports.model.WorkflowReportOptions");
            Class<?> workflowReportClass = cl.loadClass("com.comalatech.confluence.workflowreports.model.WorkflowReport");
            Class<?> workflowReportEntryClass = cl.loadClass("com.comalatech.confluence.workflowreports.model.WorkflowReportEntry");
            Object workflowReportOptions = workflowReportManagerClass.getMethod("makeOptions", MacroInfo.class).invoke(WorkflowReporterMacroDelegate.this.workflowReportManager, macroInfo);
            Object optionsMaxEntries = workflowReportOptionsClass.getMethod("getMaxEntries", new Class[0]).invoke(workflowReportOptions, new Object[0]);
            Object workflowReport = workflowReportManagerClass.getMethod("createReport", workflowReportOptionsClass, PaginationSupport.class).invoke(WorkflowReporterMacroDelegate.this.workflowReportManager, workflowReportOptions, new PaginationSupport((Integer)optionsMaxEntries));
            Object reportEntries = workflowReportClass.getMethod("getEntries", new Class[0]).invoke(workflowReport, new Object[0]);
            for (Object workflowReportEntry : (List)reportEntries) {
                Object workflowReportEntryPage = workflowReportEntryClass.getMethod("getPage", new Class[0]).invoke(workflowReportEntry, new Object[0]);
                pages.add((ContentEntityObject)workflowReportEntryPage);
            }
            return pages;
        }

        protected void findItems(List<AbstractPage> abstractPages, Criteria criteria) throws QueryException {
            List<ContentEntityObject> pages = null;
            try {
                pages = this.findContent(this.macroInfo);
            }
            catch (Exception e) {
                log.error("findContent error {}", (Object)e.getMessage(), (Object)e);
            }
            if (Objects.isNull(pages)) {
                return;
            }
            for (ContentEntityObject page : pages) {
                boolean add = true;
                for (Criterion criterion : criteria.getCriteria()) {
                    if (criterion.matches((Object)page)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                abstractPages.add((AbstractPage)page);
            }
        }
    }
}

