/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.statistics;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityDetailsRecord;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.statistics.accessor.WorkflowStatsRecordAccessor;
import com.comalatech.confluence.documentActivity.statistics.accessor.criteria.WorkflowStatsSearchCriteria;
import com.comalatech.confluence.documentActivity.statistics.validator.UsageStatsValidator;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.model.statistics.StateStatsFilter;
import com.comalatech.workflow.statistics.StateStatsService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class DefaultStateStatsService
implements StateStatsService {
    private final WorkflowStatsRecordAccessor workflowStatsRecordAccessor;
    private final UsageStatsValidator statsValidator;

    public DefaultStateStatsService(WorkflowStatsRecordAccessor workflowStatsRecordAccessor, UsageStatsValidator statsValidator) {
        this.workflowStatsRecordAccessor = workflowStatsRecordAccessor;
        this.statsValidator = statsValidator;
    }

    @Override
    public Long getMaximumTimeElapsedInState(StateStatsFilter filter) throws WorkflowException {
        WorkflowStatsSearchCriteria searchCriteria = this.validateAndBuild(filter);
        List<BaseActivityDetailsRecord> stateDetails = this.workflowStatsRecordAccessor.search(searchCriteria);
        if (stateDetails == null || stateDetails.isEmpty()) {
            return 0L;
        }
        return stateDetails.stream().mapToLong(act -> Long.parseLong(act.getValue())).max().orElse(0L);
    }

    @Override
    public Long getMinimumTimeElapsedInState(StateStatsFilter filter) throws WorkflowException {
        WorkflowStatsSearchCriteria searchCriteria = this.validateAndBuild(filter);
        List<BaseActivityDetailsRecord> stateDetails = this.workflowStatsRecordAccessor.search(searchCriteria);
        if (stateDetails == null || stateDetails.isEmpty()) {
            return 0L;
        }
        return stateDetails.stream().mapToLong(act -> Long.parseLong(act.getValue())).min().orElse(0L);
    }

    @Override
    public Double getAverageTimeElapsedInState(StateStatsFilter filter) throws WorkflowException {
        WorkflowStatsSearchCriteria searchCriteria = this.validateAndBuild(filter);
        List<BaseActivityDetailsRecord> stateDetails = this.workflowStatsRecordAccessor.search(searchCriteria);
        if (stateDetails == null || stateDetails.isEmpty()) {
            return 0.0;
        }
        return stateDetails.stream().mapToLong(act -> Long.parseLong(act.getValue())).average().orElse(0.0);
    }

    private WorkflowStatsSearchCriteria validateAndBuild(StateStatsFilter filter) throws WorkflowException {
        List<Space> spaces = this.statsValidator.validateSpaces(filter.getSpaceKeys());
        this.statsValidator.validateDates(filter.getFromDate(), filter.getToDate());
        this.statsValidator.validateState(filter.getStateName());
        return ((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)WorkflowStatsSearchCriteria.builder().stateName(filter.getStateName())).actionType(ActionType.Type.STATE.getValue())).actionSubType(ActionType.Subtype.STATE_CLOSED.getValue())).detailType(ActionDetailType.STATE_TIME_LAPSED.getValue())).spaceIds(spaces != null && !spaces.isEmpty() ? spaces.stream().map(EntityObject::getId).collect(Collectors.toList()) : null)).fromDate(filter.getFromDate())).toDate(filter.getToDate())).build();
    }
}

