/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.service;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.documentActivity.ao.ActivitySearchCriteria;
import com.comalatech.confluence.documentActivity.ao.ApprovalActivitySearchCriteria;
import com.comalatech.confluence.documentActivity.ao.accesor.ActivityRecordAccessor;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityRecord;
import com.comalatech.confluence.documentActivity.ao.mapper.ActivityRecordMapper;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.service.ApprovalActivityService;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApprovalActivityServiceImpl
implements ApprovalActivityService {
    private static final Logger log = LoggerFactory.getLogger(ApprovalActivityServiceImpl.class);
    private final ActivityRecordAccessor activityRecordAccessor;
    private final ActivityRecordMapper activityRecordMapper;

    public ApprovalActivityServiceImpl(ActivityRecordAccessor activityRecordAccessor, @ComponentImport UserAccessor userAccessor, WorkflowUserAccessor workflowUserAccessor) {
        this.activityRecordAccessor = activityRecordAccessor;
        ActorUtils actorUtils = new ActorUtils(userAccessor, workflowUserAccessor);
        this.activityRecordMapper = new ActivityRecordMapper(actorUtils);
    }

    @Override
    public List<BaseActivityRecord> getApprovalAssignees(long contentId, String approvalName, String actionSubType) {
        return this.activityRecordAccessor.searchByApproval(this.buildCriteria(Collections.singletonList(actionSubType), approvalName, contentId));
    }

    @Override
    public Activity getLatestFullyApproved(long contentId, String approvalName) {
        return this.getApprovalInstance(this.buildCriteria(Collections.singletonList(ActionType.Subtype.APPROVAL_FULLY_APPROVED.getValue()), approvalName, contentId));
    }

    @Override
    public Activity getLatestFullyRejected(long contentId, String approvalName) {
        return this.getApprovalInstance(this.buildCriteria(Collections.singletonList(ActionType.Subtype.APPROVAL_FULLY_REJECTED.getValue()), approvalName, contentId));
    }

    private Activity getApprovalInstance(ApprovalActivitySearchCriteria searchCriteria) {
        List<BaseActivityRecord> baseActivityRecords = this.activityRecordAccessor.searchByApproval(searchCriteria);
        try {
            return this.activityRecordMapper.recordToActivity(baseActivityRecords.stream().findFirst().orElse(null));
        }
        catch (Exception e) {
            log.error("There has been an error during the map of the activity record for the page {}: {}", (Object)searchCriteria.getContentId(), (Object)e.getMessage());
            return null;
        }
    }

    private ApprovalActivitySearchCriteria buildCriteria(List<String> subtype, String approvalName, Long contentId) {
        return ((ApprovalActivitySearchCriteria.ApprovalActivitySearchCriteriaBuilder)((ActivitySearchCriteria.ActivitySearchCriteriaBuilder)((ApprovalActivitySearchCriteria.ApprovalActivitySearchCriteriaBuilder)ApprovalActivitySearchCriteria.builder().actionSubType(subtype)).approvalName(approvalName)).contentId(contentId)).build();
    }
}

