/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.task;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.tasks.event.DefaultTaskDueDateExpiredEvent;
import com.comalatech.confluence.tasks.model.PageTask;
import java.util.Date;

public class TaskDueDateExpiryMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public TaskDueDateExpiryMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) {
        if (event instanceof DefaultTaskDueDateExpiredEvent) {
            DefaultTaskDueDateExpiredEvent defaultTaskDueDateExpiredEvent = (DefaultTaskDueDateExpiredEvent)event;
            return this.buildActivity((AbstractPage)defaultTaskDueDateExpiredEvent.getContent(), defaultTaskDueDateExpiredEvent.getState(), defaultTaskDueDateExpiredEvent.getTask(), defaultTaskDueDateExpiredEvent.getTimestamp());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, PageTask pageTask, long timestamp) {
        Actor actor = this.actorUtils.buildWorkflowActor();
        ActionDetails details = new ActionDetails();
        details.addDetail(ActionDetailType.TASK_NAME, pageTask.getName());
        details.addAll(this.buildStateActionDetails(state));
        Date expiredDate = pageTask.getDueDate();
        if (expiredDate != null) {
            details.addDetail(ActionDetailType.TASK_DUE_DATE, String.valueOf(expiredDate.getTime()));
        }
        Action action = new Action(new ActionType(ActionType.Type.TASK, ActionType.Subtype.TASK_DUE_DATE_EXPIRED), actor, details);
        return new Activity(TaskDueDateExpiryMapper.buildTarget((ContentEntityObject)abstractPage), timestamp, action);
    }
}

