/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.approval;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.events.BlogPostApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.PageApprovalAssignedEvent;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.workflow.model.Assignment;

public class ApprovalAssignedMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public ApprovalAssignedMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) throws WorkflowUserException {
        if (event instanceof PageApprovalAssignedEvent) {
            PageApprovalAssignedEvent pageApprovalAssignedEvent = (PageApprovalAssignedEvent)event;
            return this.buildActivity(pageApprovalAssignedEvent.getAbstractPage(), pageApprovalAssignedEvent.getState(), pageApprovalAssignedEvent.getApprovalCheck(), pageApprovalAssignedEvent.getApprovalCheck().getCurrentAssignment());
        }
        if (event instanceof BlogPostApprovalAssignedEvent) {
            BlogPostApprovalAssignedEvent blogPostApprovalAssignedEvent = (BlogPostApprovalAssignedEvent)event;
            return this.buildActivity(blogPostApprovalAssignedEvent.getAbstractPage(), blogPostApprovalAssignedEvent.getState(), blogPostApprovalAssignedEvent.getApprovalCheck(), blogPostApprovalAssignedEvent.getApprovalCheck().getCurrentAssignment());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, ApprovalCheck approvalCheck, Assignment assignment) throws WorkflowUserException {
        Actor actor = this.actorUtils.buildActor(assignment.getPerformer());
        ActionDetails details = this.buildApprovalsActionDetails(approvalCheck.getName(), approvalCheck.getId(), assignment.getComment());
        Actor assignedUser = this.actorUtils.buildActor(assignment.getAssignee());
        details.addDetail(ActionDetailType.APPROVAL_USER_ASSIGNED, assignedUser.getId(), null, assignedUser);
        details.addAll(this.buildRoleNameActionDetails(((ApprovalCheck.AssigneeHistory)assignment).getRolename()));
        details.addAll(this.buildStateActionDetails(state));
        Action action = new Action(new ActionType(ActionType.Type.APPROVAL, ActionType.Subtype.APPROVAL_ASSIGNED), actor, details);
        return new Activity(ApprovalAssignedMapper.buildTarget((ContentEntityObject)abstractPage), assignment.getDate().getTime(), action);
    }
}

