/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.mappers.activity.state;

import com.comalatech.confluence.cloud.migration.entity.domain.activity.state.StateDueDate;
import com.comalatech.confluence.cloud.migration.usecases.mappers.ActivityMapper;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.util.FancyDateFormatter;

public class StateDueDateMapper
extends ActivityMapper {
    private static final String SET_EXPIRE = "set-expire";
    public static final String CLOUD_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    @Override
    protected StateDueDate map(Activity activity) {
        if (activity == null) {
            return null;
        }
        StateDueDate stateDueDate = new StateDueDate();
        this.populateCommonFields(stateDueDate, activity);
        stateDueDate.setAction(SET_EXPIRE);
        if (ActionType.Subtype.STATE_EXPIRY_UPDATE.equals((Object)activity.getAction().getActionType().getSubtype())) {
            stateDueDate.setDueDate(FancyDateFormatter.convertEpochToFormattedDate(Long.parseLong(activity.getAction().getActionDetails().getDetail(ActionDetailType.NEW_EXPIRY_DATE).getValue()), CLOUD_DATE_FORMAT));
        }
        if (activity.getAction() != null && activity.getAction().getActors() != null) {
            stateDueDate.setUser(this.actorListToPerformer(activity.getAction().getActors()));
        }
        return stateDueDate;
    }

    @Override
    protected boolean shouldApply(Activity activity) {
        if (activity == null) {
            return false;
        }
        return activity.getAction() != null && activity.getAction().getActionType() != null && ActionType.Type.STATE.equals((Object)activity.getAction().getActionType().getType()) && ActionType.Subtype.STATE_EXPIRY_UPDATE.equals((Object)activity.getAction().getActionType().getSubtype());
    }
}

