/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.mappers;

import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.Approval;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.confluence.workflow.model.DecoratedApprovalCheck;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ApprovalsMapper {
    private final UserAccessor userAccessor;
    private static final String USER_AND_PASSWORD = "user+password";

    public ApprovalsMapper(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public Approval map(DecoratedApprovalCheck decoratedApproval) {
        if (decoratedApproval == null) {
            return null;
        }
        Approval approval = new Approval();
        approval.setName(decoratedApproval.getName());
        approval.setMinimum(decoratedApproval.getMinimumApprovers() == 0 ? 1 : decoratedApproval.getMinimumApprovers());
        approval.setApproveLabel(decoratedApproval.getApproveLabel());
        approval.setRejectLabel(decoratedApproval.getRejectLabel());
        approval.setAssignable(decoratedApproval.getApproval().isAssignable());
        approval.setApprovers(this.getApprovers(decoratedApproval));
        if (0 != decoratedApproval.getCredentials()) {
            approval.setCredentials(USER_AND_PASSWORD);
        }
        return approval;
    }

    private List<String> getApprovers(DecoratedApprovalCheck approval) {
        Approver[] _approvers;
        if (approval.getApprovalCheck() == null) {
            return null;
        }
        HashSet<String> combinedApprovers = new HashSet<String>();
        String[] requiredApprovers = approval.getApprovalCheck().getRequiredApprovers();
        if (requiredApprovers != null) {
            combinedApprovers.addAll(Arrays.asList(requiredApprovers));
        }
        if ((_approvers = approval.getApprovalCheck().getApprovers()) != null) {
            combinedApprovers.addAll(Arrays.stream(_approvers).map(Approver::getUserName).collect(Collectors.toList()));
        }
        List users = combinedApprovers.stream().map(arg_0 -> ((UserAccessor)this.userAccessor).getUserByName(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> approvers = users.stream().map((? super T user) -> user.getKey().getStringValue()).collect(Collectors.toList());
        return !approvers.isEmpty() ? approvers : null;
    }
}

