/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.mappers;

import com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity;
import com.comalatech.confluence.cloud.migration.usecases.mappers.ActorMapper;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import java.util.List;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ActivityMapper {
    private static final Logger log = LoggerFactory.getLogger(ActivityMapper.class);
    private final ActorMapper actorMapper = Mappers.getMapper(ActorMapper.class);

    protected abstract Activity map(com.comalatech.confluence.documentActivity.domain.entities.Activity var1);

    protected abstract boolean shouldApply(com.comalatech.confluence.documentActivity.domain.entities.Activity var1);

    protected void populateCommonFields(Activity targetActivity, com.comalatech.confluence.documentActivity.domain.entities.Activity sourceActivity) {
        if (sourceActivity.getAction() != null && sourceActivity.getAction().getActionDetails() != null) {
            targetActivity.setName(sourceActivity.getAction().getActionDetails().getDetail(ActionDetailType.STATE_NAME).getValue());
            targetActivity.setComment(sourceActivity.getAction().getActionDetails().getDetail(ActionDetailType.STATE_COMMENT).getValue());
        }
        if (sourceActivity.getTarget() != null) {
            targetActivity.setContentVersion(sourceActivity.getTarget().getTargetVersion());
        }
        targetActivity.setTimestamp(sourceActivity.getMoment());
    }

    protected com.comalatech.confluence.cloud.migration.entity.domain.activity.Actor actorListToPerformer(List<Actor> list) {
        if (list == null) {
            return null;
        }
        com.comalatech.confluence.cloud.migration.entity.domain.activity.Actor actor = null;
        if (!list.isEmpty()) {
            actor = this.actorMapper.pageActivityActorToMigrationActivityActor(list.get(0));
        }
        return actor;
    }
}

