/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.listener;

import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.ConfluenceSpaceContainerV1;
import com.atlassian.migration.app.ContainerType;
import com.atlassian.migration.app.PaginatedContainers;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableListener;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.Migration;
import com.comalatech.confluence.cloud.migration.usecases.contracts.MigrationGenerator;
import com.comalatech.confluence.cloud.migration.usecases.contracts.Presenter;
import com.comalatech.confluence.license.ComalaDocumentAppManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class WorkflowsCloudMigrationListener
implements DiscoverableListener {
    private static final Logger log = LoggerFactory.getLogger(WorkflowsCloudMigrationListener.class);
    private final PluginLicenseManager licenseManager;
    private final Presenter<File> fileJsonPresenter;
    private final Presenter<String> jsonPresenter;
    private final List<MigrationGenerator> migrationGenerators;
    private final ObjectMapper objectMapper;
    private final ComalaDocumentAppManager comalaDocumentAppManager;
    private static final int SPACE_CONTAINERS_BATCH = 50;

    public WorkflowsCloudMigrationListener(@ComponentImport PluginLicenseManager pluginLicenseManager, @Qualifier(value="fileJsonPresenter") Presenter<File> fileJsonPresenter, @Qualifier(value="jsonPresenter") Presenter<String> jsonPresenter, ComalaDocumentAppManager comalaDocumentAppManager, List<MigrationGenerator> migrationGenerators) {
        this.licenseManager = pluginLicenseManager;
        this.fileJsonPresenter = fileJsonPresenter;
        this.migrationGenerators = migrationGenerators;
        this.jsonPresenter = jsonPresenter;
        this.comalaDocumentAppManager = comalaDocumentAppManager;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public void onStartAppMigration(AppCloudMigrationGateway gateway, String transferId, MigrationDetailsV1 migrationDetails) {
        try {
            log.info("Migration context summary: {}", (Object)this.objectMapper.writeValueAsString(migrationDetails));
            PaginatedContainers paginatedSiteContainers = gateway.getPaginatedContainers(transferId, ContainerType.ConfluenceSpace, 50);
            LinkedHashSet<String> spaceKeyList = new LinkedHashSet<String>();
            while (paginatedSiteContainers.next()) {
                spaceKeyList.addAll(WorkflowsCloudMigrationListener.getSpaceKeys(paginatedSiteContainers));
            }
            List<Migration> migrations = this.migrationGenerators.stream().map(generator -> {
                try {
                    return generator.generate(gateway, new ArrayList<String>(spaceKeyList), transferId, migrationDetails);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            migrations.forEach(migration -> {
                File jsonFile = this.fileJsonPresenter.present(migration);
                try {
                    log.info("Sending {} bytes of data for transferId {} and label {} ", new Object[]{jsonFile.length(), transferId, migration.label});
                    this.sendActivitiesToMigrationService(gateway, transferId, jsonFile, migration.label + "-" + this.comalaDocumentAppManager.getVersionNumber());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            log.error("Error during the migration process", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static List<String> getSpaceKeys(PaginatedContainers paginatedSiteContainers) {
        return paginatedSiteContainers.getContainers().stream().filter(ConfluenceSpaceContainerV1.class::isInstance).map(container -> ((ConfluenceSpaceContainerV1)container).getKey()).collect(Collectors.toList());
    }

    private void sendActivitiesToMigrationService(AppCloudMigrationGateway gateway, String transferId, File jsonActivities, String label) throws IOException {
        try (OutputStream atlassianMigrationDataStream = gateway.createAppData(transferId, label);
             InputStream activitiesDataStream = Files.newInputStream(jsonActivities.toPath(), new OpenOption[0]);){
            IOUtils.copy((InputStream)activitiesDataStream, (OutputStream)atlassianMigrationDataStream);
        }
    }

    @Override
    public String getCloudAppKey() {
        return this.licenseManager.getPluginKey();
    }

    @Override
    public String getServerAppKey() {
        return this.licenseManager.getPluginKey();
    }

    @Override
    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_PRODUCT, AccessScope.MIGRATION_TRACING_IDENTITY).collect(Collectors.toCollection(HashSet::new));
    }
}

