/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.tasks;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.comalatech.confluence.cloud.migration.entity.domain.metadata.Metadata;
import com.comalatech.confluence.cloud.migration.service.CloudMigrationContentService;
import com.comalatech.confluence.cloud.migration.tasks.ExportMetadataRecord;
import com.comalatech.confluence.cloud.migration.tasks.MigrationTaskStatus;
import com.comalatech.confluence.dataextractor.JsonContentPropertyService;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.util.ImpersonationUtil;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportMetadataTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(ExportMetadataTask.class);
    private final String spaceKey;
    private final ExportMetadataRecord exportMetadataTaskRecord;
    private final CloudMigrationContentService defaultCloudMigrationContentService;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final JsonContentPropertyService jsonContentPropertyService;
    private final ContentService contentService;
    private final ComalaI18nBean i18nBean;
    private final PageManager pageManager;
    private final ImpersonationUtil impersonationUtil;
    private final LinkedHashMap<Long, List<Metadata>> metadataRecords;
    private static final String METADATA_JSON_CONTENT_PROPERTY_KEY = "cw.migration.metadata";

    public ExportMetadataTask(String spaceKey, ExportMetadataRecord exportMetadataTaskRecord, CloudMigrationContentService defaultCloudMigrationContentService, ReadWriteTransactionService readWriteTransactionService, JsonContentPropertyService jsonContentPropertyService, ContentService contentService, ComalaI18nBean i18nBean, ImpersonationUtil impersonationUtil, PageManager pageManager, LinkedHashMap<Long, List<Metadata>> metadataRecords) {
        this.spaceKey = spaceKey;
        this.exportMetadataTaskRecord = exportMetadataTaskRecord;
        this.defaultCloudMigrationContentService = defaultCloudMigrationContentService;
        this.jsonContentPropertyService = jsonContentPropertyService;
        this.readWriteTransactionService = readWriteTransactionService;
        this.i18nBean = i18nBean;
        this.impersonationUtil = impersonationUtil;
        this.pageManager = pageManager;
        this.metadataRecords = metadataRecords;
        this.contentService = contentService;
    }

    protected void runInternal() {
        try {
            this.exportMetadataTaskRecord.setStartedTimestamp(new Date().getTime());
            this.exportMetadataTaskRecord.setStatus(MigrationTaskStatus.IN_PROGRESS);
            this.defaultCloudMigrationContentService.setExportMetadataTaskStatus(this.spaceKey, this.exportMetadataTaskRecord);
            this.readWriteTransactionService.executeInReadWriteTransaction(() -> {
                log.debug("Starting long running task to attach activity csv to pages in space: {}", (Object)this.spaceKey);
                if (this.metadataRecords != null && !this.metadataRecords.isEmpty()) {
                    log.debug("Long running task set to IN PROGRESS for space: {}", (Object)this.spaceKey);
                    this.progress.setCurrentCount(0);
                    this.progress.setTotalObjects(this.metadataRecords.size());
                    AtomicInteger currentContent = new AtomicInteger(1);
                    this.metadataRecords.forEach((record, data) -> {
                        Content content = this.contentService.find(new Expansion[0]).withId(ContentId.of((long)record)).fetch().orElse(null);
                        if (content != null) {
                            String jsonContentProperty;
                            try {
                                jsonContentProperty = ExportMetadataTask.convertMetadataListToJson(data);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            AbstractPage abstractPage = this.pageManager.getAbstractPage(content.getId().asLong());
                            this.impersonationUtil.impersonatedOperation(abstractPage, () -> this.jsonContentPropertyService.updateOrCreateNonTransactional(content, METADATA_JSON_CONTENT_PROPERTY_KEY, jsonContentProperty));
                            this.progress.setPercentage(currentContent.get(), this.metadataRecords.size());
                            currentContent.getAndIncrement();
                            this.progress.setCurrentCount(this.progress.getCurrentCount() + 1);
                            this.progress.setStatus(this.i18nBean.getText("awp.space.exportMetadataJob.progress.status", new Object[]{this.progress.getCurrentCount(), this.progress.getTotal()}));
                        } else {
                            log.warn("No content found for id {}, could not exist or be related to space metadata", record);
                        }
                    });
                    this.progress.setCurrentCount(this.metadataRecords.size());
                    log.debug("Long running task set to COMPLETED for space: {}", (Object)this.spaceKey);
                } else {
                    log.debug("No content with metadata to process, setting long running task to COMPLETED for space: {}", (Object)this.spaceKey);
                }
                this.exportMetadataTaskRecord.setStatus(MigrationTaskStatus.COMPLETED);
                this.exportMetadataTaskRecord.setEndedTimestamp(new Date().getTime());
                return null;
            });
        }
        catch (Exception e) {
            this.exportMetadataTaskRecord.setStatus(MigrationTaskStatus.FAIL);
            this.exportMetadataTaskRecord.setEndedTimestamp(new Date().getTime());
            this.progress.setStatus(this.i18nBean.getText("awp.space.exportMetadataJob.error"));
            log.error("Error processing content metadata to convert into json content properties", (Throwable)e);
        }
        this.progress.setPercentage(100);
        this.progress.setCompletedSuccessfully(!MigrationTaskStatus.FAIL.equals((Object)this.exportMetadataTaskRecord.getStatus()));
        this.defaultCloudMigrationContentService.setExportMetadataTaskStatus(this.spaceKey, this.exportMetadataTaskRecord);
    }

    public String getName() {
        return this.i18nBean.getText("awp.space.exportMetadataJob.task.name");
    }

    public static String convertMetadataListToJson(List<Metadata> metadataList) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode rootNode = objectMapper.createObjectNode();
        for (Metadata metadata : metadataList) {
            rootNode.put(metadata.getName().split("\\.")[1], metadata.getValue());
        }
        return objectMapper.writeValueAsString(rootNode);
    }
}

