/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.api.model.content;

import com.atlassian.confluence.api.model.content.History;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.util.GeneralUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryConf9Compatibility {
    private static final Logger log = LoggerFactory.getLogger(HistoryConf9Compatibility.class);

    public static Date getCreatedAt(History history) {
        OffsetDateTime createdAtOffset;
        if (GeneralUtil.getVersionNumber().startsWith(String.valueOf(9)) && (createdAtOffset = HistoryConf9Compatibility._getCreatedAt(history)) != null) {
            return Date.from(createdAtOffset.toInstant());
        }
        try {
            Class<?> dateTimeClass = HistoryConf9Compatibility.getConfluenceDateTimeClass();
            Method getCreatedDateMethod = history.getClass().getMethod("getCreatedDate", new Class[0]);
            Object lastModified = getCreatedDateMethod.invoke((Object)history, new Object[0]);
            Object dateTimeInstance = dateTimeClass.cast(lastModified);
            Method toDateMethod = dateTimeClass.getMethod("toDate", new Class[0]);
            return (Date)toDateMethod.invoke(dateTimeInstance, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static OffsetDateTime _getCreatedAt(History history) {
        try {
            Method queryMethod = History.class.getMethod("getCreatedAt", new Class[0]);
            return (OffsetDateTime)queryMethod.invoke((Object)history, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error("Error detected while retrieving createdAt through compatibility layer", (Throwable)e);
            return null;
        }
    }

    private static Class<?> getConfluenceDateTimeClass() throws ClassNotFoundException {
        ClassLoader confluenceClassLoader = SearchResult.class.getClassLoader();
        return Class.forName("org.joda.time.DateTime", true, confluenceClassLoader);
    }
}

