/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhocworkflows.rest.model;

import com.comalatech.confluence.adhocworkflows.rest.model.AbstractApproval;
import com.comalatech.confluence.adhocworkflows.rest.model.Approver;
import com.comalatech.confluence.workflow.model.DecoratedApprovalCheck;
import com.comalatech.workflow.model.ApprovalAction;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="approval")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Approval
extends AbstractApproval {
    boolean canAssign;
    private String hint;
    private String message;
    private List<Approver> approvers;
    private String filterGroups;
    private String filterUsers;
    private String filterExcludedUsers;
    private Integer minimumRequiredApprovers;
    private boolean isOneApproverOnly = false;
    private String approveLabel;
    private String rejectLabel;
    boolean rolesEnabled;

    public Approval() {
    }

    public Approval(ApprovalAction approvalAction) {
        super(approvalAction.getName(), approvalAction.isApproved(), approvalAction.isRejected(), approvalAction.getAssignments().isEmpty() && approvalAction.canApprove(), approvalAction.getAssignments().isEmpty() && approvalAction.canReject(), approvalAction.getSignatureType());
        this.filterUsers = approvalAction.getFilterUsers();
        this.filterGroups = approvalAction.getFilterGroups();
        this.filterExcludedUsers = approvalAction.getFilterExcludedUsers();
        this.approveLabel = approvalAction.getApproveLabel();
        this.rejectLabel = approvalAction.getRejectLabel();
        this.approvers = new ArrayList<Approver>();
        this.hint = approvalAction.getHint();
        if (approvalAction.getMinimumApprovers() > 1) {
            this.minimumRequiredApprovers = approvalAction.getMinimumApprovers();
        }
        if (approvalAction.getSelector() != null) {
            if (!approvalAction.getSelector().isFixed()) {
                this.canAssign = true;
                int minimumApprovers = approvalAction.getSelector().getMinAssignees();
                if (minimumApprovers > 1 && approvalAction.getAssignments().size() < minimumApprovers) {
                    this.message = this.hint;
                }
            }
            if (approvalAction.getSelector().isOneApproverOnly()) {
                this.isOneApproverOnly = true;
                this.minimumRequiredApprovers = 1;
            }
        }
        if (this.canAssign) {
            this.addAction(AbstractApproval.ValidActions.ASSIGN);
        }
        if (approvalAction instanceof DecoratedApprovalCheck) {
            this.rolesEnabled = approvalAction.isRolesEnabled();
        }
    }

    public boolean isCanAssign() {
        return this.canAssign;
    }

    public boolean isRolesEnabled() {
        return this.rolesEnabled;
    }

    public void addApprover(Approver approver) {
        this.approvers.add(approver);
    }

    public List<Approver> getApprovers() {
        return this.approvers;
    }

    public void setApprovers(List<Approver> approvers) {
        this.approvers = approvers;
    }

    public String getHint() {
        return this.hint;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFilterGroups() {
        return this.filterGroups;
    }

    public String getFilterUsers() {
        return this.filterUsers;
    }

    public String getFilterExcludedUsers() {
        return this.filterExcludedUsers;
    }

    public Integer getMinimumRequiredApprovers() {
        return this.minimumRequiredApprovers;
    }

    public String getApproveLabel() {
        return this.approveLabel;
    }

    public String getRejectLabel() {
        return this.rejectLabel;
    }

    public boolean isOneApproverOnly() {
        return this.isOneApproverOnly;
    }

    public void setExpandedGroupsMembers(String expandedGroupsMembers, String notExpandedGroups) {
        this.filterUsers = expandedGroupsMembers;
        this.filterGroups = notExpandedGroups;
    }
}

