/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting.macro;

import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.customware.confluence.reporting.DefaultReport;
import net.customware.confluence.reporting.ExecutionException;
import net.customware.confluence.reporting.Executor;
import net.customware.confluence.reporting.Report;
import net.customware.confluence.reporting.ReportBuilder;
import net.customware.confluence.reporting.ReportException;
import net.customware.confluence.reporting.ReportOutput;
import net.customware.confluence.reporting.ReportSetup;
import net.customware.confluence.reporting.Sortable;
import net.customware.confluence.reporting.macro.AbstractReportingMacro;
import net.customware.confluence.reporting.query.Query;
import net.customware.confluence.reporting.query.QueryException;
import net.customware.confluence.reporting.query.Results;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.supplier.SupplierAssistant;
import org.randombits.confluence.supplier.SupplierException;
import org.randombits.confluence.supplier.UnsupportedContextException;
import org.randombits.confluence.support.MacroInfo;

public abstract class AbstractReportMacro<Setup extends ReportSetup<Output>, Output extends ReportOutput>
extends AbstractReportingMacro {
    private static final RenderMode RENDER_MODE = RenderMode.suppress((long)256L);

    @Override
    protected String report(final MacroInfo info) throws MacroException, ReportException {
        return ReportBuilder.executeRoot(info.getPageContext(), new Executor<String>(){

            @Override
            public String execute() throws ReportException {
                final Object setup = AbstractReportMacro.this.createReportSetup(info);
                String error = AbstractReportMacro.this.initSetup(setup, info);
                if (error != null) {
                    return error;
                }
                List outputs = setup.getOutputs();
                if (outputs == null || outputs.size() == 0) {
                    throw new ExecutionException("Please supply the report output setup.");
                }
                Query<Object> query = setup.getQuery();
                if (query == null) {
                    throw new ExecutionException("Please supply a reporter macro.");
                }
                final Report report = AbstractReportMacro.this.createReport(setup, info);
                report.setParent(ReportBuilder.getCurrentReport());
                try {
                    final Results<Object> results = query.execute();
                    String value = ReportBuilder.executeReport(report, new Executor<String>(){

                        @Override
                        public String execute() throws ReportException {
                            try {
                                StringBuffer out = new StringBuffer();
                                int firstResult = report.getSetup().getFirstResult();
                                for (int count = 1; results.hasNext() && count < firstResult; ++count) {
                                    results.next();
                                }
                                if (results.hasNext()) {
                                    String header = setup.getHeader();
                                    if (header != null) {
                                        out.append(AbstractReportMacro.this.render(header));
                                    }
                                    AbstractReportMacro.this.handleBeforeReport(out, report, info);
                                    AbstractReportMacro.this.processItems(results, out, report, info, report.getSetup().getDepth());
                                    AbstractReportMacro.this.handleAfterReport(out, report, info);
                                    String footer = setup.getFooter();
                                    if (footer != null) {
                                        out.append(AbstractReportMacro.this.render(footer));
                                    }
                                } else {
                                    String empty = setup.getEmpty();
                                    if (empty != null) {
                                        out.append(AbstractReportMacro.this.render(empty));
                                    }
                                }
                                return out.toString();
                            }
                            catch (SupplierException e) {
                                throw new ExecutionException("Error processing the report: " + e.getMessage(), e);
                            }
                            catch (UnsupportedContextException e) {
                                throw new ExecutionException("Error processing the report: " + e.getMessage(), e);
                            }
                        }
                    });
                    results.close();
                    return value;
                }
                catch (QueryException e) {
                    throw new ExecutionException(e.getMessage(), e);
                }
            }
        });
    }

    private String initSetup(ReportSetup<Output> setup, final MacroInfo info) throws ReportException {
        return ReportBuilder.executeContext(setup, new Executor<String>(){

            @Override
            public String execute() throws ReportException {
                String rendered = AbstractReportMacro.this.renderWiki(info.getMacroBody(), RENDER_MODE);
                if (rendered != null && rendered.trim().length() > 0) {
                    return rendered;
                }
                return null;
            }
        });
    }

    protected abstract Setup createReportSetup(MacroInfo var1) throws ReportException;

    private void processItems(Iterator<?> i, StringBuffer out, Report<Setup, Output> report, MacroInfo info, int depth) throws SupplierException, ReportException, UnsupportedContextException {
        int maxResults = report.getSetup().getMaxResults();
        int count = 0;
        this.handleBeforeItems(out, report, info, depth);
        while (i.hasNext() && (maxResults < 1 || count < maxResults)) {
            Object item = i.next();
            if (++count > 1) {
                this.handleBetweenItems(out, report, info, depth);
            }
            this.processItem(item, out, report, info, depth);
        }
        this.handleAfterItems(out, report, info, depth);
    }

    protected abstract void handleBetweenItems(StringBuffer var1, Report<Setup, Output> var2, MacroInfo var3, int var4) throws ReportException;

    protected abstract void handleAfterItems(StringBuffer var1, Report<Setup, Output> var2, MacroInfo var3, int var4) throws ReportException;

    protected abstract void handleBeforeItems(StringBuffer var1, Report<Setup, Output> var2, MacroInfo var3, int var4) throws ReportException;

    private void processItem(Object item, StringBuffer out, Report<Setup, Output> report, MacroInfo info, int currentDepth) throws SupplierException, ReportException, UnsupportedContextException {
        report.setCurrentItem(item);
        this.handleBeforeItem(item, out, report, info, currentDepth);
        for (ReportOutput output : report.getOutputs()) {
            this.handleBeforeOutput(output, out, report, info);
            Criterion criterion = output.getCriterion();
            if (criterion == null || criterion.matches(item)) {
                this.handleOutput(output, out, report, info);
            }
            this.handleAfterOutput(output, out, report, info);
        }
        this.handleAfterItem(item, out, report, info, currentDepth);
        if (currentDepth > 0) {
            Collection<?> children;
            try {
                children = SupplierAssistant.getInstance().findChildren(item, null);
            }
            catch (SupplierException e) {
                throw new ExecutionException("A problem occurred while retrieving children: " + e.getMessage(), e);
            }
            catch (UnsupportedContextException e) {
                throw new ExecutionException("A problem occurred while retrieving children: " + e.getMessage(), e);
            }
            if (children != null) {
                Comparator comparator = null;
                if (report.getSetup().isSortDescendents() && report.getQuery() instanceof Sortable) {
                    comparator = ((Sortable)((Object)report.getQuery())).getComparator();
                }
                if (comparator != null) {
                    ArrayList list = new ArrayList(children);
                    Collections.sort(list, comparator);
                    children = list;
                }
                this.processItems(children.iterator(), out, report, info, currentDepth - 1);
            }
        }
    }

    protected abstract void handleAfterOutput(Output var1, StringBuffer var2, Report<Setup, Output> var3, MacroInfo var4) throws ReportException;

    protected abstract void handleBeforeOutput(Output var1, StringBuffer var2, Report<Setup, Output> var3, MacroInfo var4) throws ReportException;

    protected abstract void handleBeforeItem(Object var1, StringBuffer var2, Report<Setup, Output> var3, MacroInfo var4, int var5) throws ReportException;

    protected abstract void handleAfterItem(Object var1, StringBuffer var2, Report<Setup, Output> var3, MacroInfo var4, int var5) throws ReportException;

    protected void handleOutput(Output output, StringBuffer out, Report<Setup, Output> report, MacroInfo info) throws SupplierException, ReportException, UnsupportedContextException {
        out.append(this.renderOutput(output, report, this.getOutputRenderMode()));
    }

    protected abstract RenderMode getOutputRenderMode();

    protected abstract void handleAfterReport(StringBuffer var1, Report<Setup, Output> var2, MacroInfo var3) throws ReportException;

    protected abstract void handleBeforeReport(StringBuffer var1, Report<Setup, Output> var2, MacroInfo var3) throws ReportException;

    protected Report<Setup, Output> createReport(Setup setup, MacroInfo info) throws ExecutionException {
        return new DefaultReport(setup);
    }

    private String render(String wikiText) throws ReportException {
        return this.renderWiki(wikiText, RENDER_MODE);
    }

    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    protected String renderOutput(Output output, Report<Setup, Output> report, RenderMode renderMode) throws SupplierException, ReportException, UnsupportedContextException {
        Object value = this.getInjectedValue(output, report.getCurrentItem());
        return this.renderWiki(value == null ? "" : value.toString(), renderMode);
    }

    protected Object getInjectedValue(Output output, Object context) throws SupplierException, UnsupportedContextException {
        Object value = output.getValue();
        if (output.isInjected()) {
            value = SupplierAssistant.getInstance().injectValues(context, output.getValue());
        }
        return value;
    }
}

