/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.workflow.model.document.activity;

import com.comalatech.workflow.model.document.activity.DocumentActivityActionTypesFilter;
import com.comalatech.workflow.model.document.activity.DocumentActivityInvolvedUsers;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@ApiModel(description="Filters to apply to a Document Activity search in a query")
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown=true)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DocumentActivityQueryFilter {
    @ApiModelProperty(value="Limits the value of the activity moment to be greater or equals this value expressed in epoch millis", example="12345323")
    private Long fromDate;
    @ApiModelProperty(value="Limits the value of the activity moment to be lesser or equals this value expressed in epoch millis", example="12345323")
    private Long toDate;
    @ApiModelProperty(value="Limits the actor of the activity to be one of these values, represented by user ids.", example="[\"8aa7c63adfie24017bc8fdba710000\"]")
    private List<String> actors;
    @ApiModelProperty(value="Limits the participant of the activity to be one of these values, represented by user ids.", example="[\"8aa7c63adfie24017bc8fdba710000\"]")
    private List<String> participants;
    @ApiModelProperty(value="List of Activity action types (STATE, APPROVAL, TASK and READ_CONFIRMATION) and its list of subtypes")
    private List<DocumentActivityActionTypesFilter> types;
    @ApiModelProperty(value="list of state names in which the actions took place", example="[\"in Progress\", \"approved\"]")
    private List<String> stateNames;

    public DocumentActivityQueryFilter() {
    }

    public Long getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Long fromDate) {
        this.fromDate = fromDate;
    }

    public Long getToDate() {
        return this.toDate;
    }

    public void setToDate(Long toDate) {
        this.toDate = toDate;
    }

    public void setInvolvedUsers(DocumentActivityInvolvedUsers involvedUsers) {
        if (involvedUsers.getActors() != null) {
            this.setActors(involvedUsers.getActors());
        } else if (involvedUsers.getParticipants() != null) {
            this.setParticipants(involvedUsers.getParticipants());
        }
    }

    public List<DocumentActivityActionTypesFilter> getTypes() {
        return this.types;
    }

    public void setTypes(List<DocumentActivityActionTypesFilter> types) {
        this.types = types;
    }

    public List<String> getStateNames() {
        return this.stateNames;
    }

    public void setStateNames(List<String> stateNames) {
        this.stateNames = stateNames;
    }

    public List<String> getActors() {
        return this.actors;
    }

    public void setActors(List<String> actors) {
        this.actors = actors;
    }

    public List<String> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<String> participants) {
        this.participants = participants;
    }

    protected DocumentActivityQueryFilter(DocumentActivityQueryFilterBuilder<?, ?> b) {
        this.fromDate = b.fromDate;
        this.toDate = b.toDate;
        this.actors = b.actors;
        this.participants = b.participants;
        this.types = b.types;
        this.stateNames = b.stateNames;
    }

    public static DocumentActivityQueryFilterBuilder<?, ?> builder() {
        return new DocumentActivityQueryFilterBuilderImpl();
    }

    public DocumentActivityQueryFilterBuilder<?, ?> toBuilder() {
        return new DocumentActivityQueryFilterBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentActivityQueryFilter)) {
            return false;
        }
        DocumentActivityQueryFilter other = (DocumentActivityQueryFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$fromDate = this.getFromDate();
        Long other$fromDate = other.getFromDate();
        if (this$fromDate == null ? other$fromDate != null : !((Object)this$fromDate).equals(other$fromDate)) {
            return false;
        }
        Long this$toDate = this.getToDate();
        Long other$toDate = other.getToDate();
        if (this$toDate == null ? other$toDate != null : !((Object)this$toDate).equals(other$toDate)) {
            return false;
        }
        List<String> this$actors = this.getActors();
        List<String> other$actors = other.getActors();
        if (this$actors == null ? other$actors != null : !((Object)this$actors).equals(other$actors)) {
            return false;
        }
        List<String> this$participants = this.getParticipants();
        List<String> other$participants = other.getParticipants();
        if (this$participants == null ? other$participants != null : !((Object)this$participants).equals(other$participants)) {
            return false;
        }
        List<DocumentActivityActionTypesFilter> this$types = this.getTypes();
        List<DocumentActivityActionTypesFilter> other$types = other.getTypes();
        if (this$types == null ? other$types != null : !((Object)this$types).equals(other$types)) {
            return false;
        }
        List<String> this$stateNames = this.getStateNames();
        List<String> other$stateNames = other.getStateNames();
        return !(this$stateNames == null ? other$stateNames != null : !((Object)this$stateNames).equals(other$stateNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocumentActivityQueryFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $fromDate = this.getFromDate();
        result = result * 59 + ($fromDate == null ? 43 : ((Object)$fromDate).hashCode());
        Long $toDate = this.getToDate();
        result = result * 59 + ($toDate == null ? 43 : ((Object)$toDate).hashCode());
        List<String> $actors = this.getActors();
        result = result * 59 + ($actors == null ? 43 : ((Object)$actors).hashCode());
        List<String> $participants = this.getParticipants();
        result = result * 59 + ($participants == null ? 43 : ((Object)$participants).hashCode());
        List<DocumentActivityActionTypesFilter> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        List<String> $stateNames = this.getStateNames();
        result = result * 59 + ($stateNames == null ? 43 : ((Object)$stateNames).hashCode());
        return result;
    }

    public String toString() {
        return "DocumentActivityQueryFilter(fromDate=" + this.getFromDate() + ", toDate=" + this.getToDate() + ", actors=" + this.getActors() + ", participants=" + this.getParticipants() + ", types=" + this.getTypes() + ", stateNames=" + this.getStateNames() + ")";
    }

    private static final class DocumentActivityQueryFilterBuilderImpl
    extends DocumentActivityQueryFilterBuilder<DocumentActivityQueryFilter, DocumentActivityQueryFilterBuilderImpl> {
        private DocumentActivityQueryFilterBuilderImpl() {
        }

        @Override
        protected DocumentActivityQueryFilterBuilderImpl self() {
            return this;
        }

        @Override
        public DocumentActivityQueryFilter build() {
            return new DocumentActivityQueryFilter(this);
        }
    }

    public static abstract class DocumentActivityQueryFilterBuilder<C extends DocumentActivityQueryFilter, B extends DocumentActivityQueryFilterBuilder<C, B>> {
        private Long fromDate;
        private Long toDate;
        private List<String> actors;
        private List<String> participants;
        private List<DocumentActivityActionTypesFilter> types;
        private List<String> stateNames;

        protected B $fillValuesFrom(C instance) {
            DocumentActivityQueryFilterBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DocumentActivityQueryFilter instance, DocumentActivityQueryFilterBuilder<?, ?> b) {
            b.fromDate(instance.fromDate);
            b.toDate(instance.toDate);
            b.actors(instance.actors);
            b.participants(instance.participants);
            b.types(instance.types);
            b.stateNames(instance.stateNames);
        }

        public B fromDate(Long fromDate) {
            this.fromDate = fromDate;
            return this.self();
        }

        public B toDate(Long toDate) {
            this.toDate = toDate;
            return this.self();
        }

        public B actors(List<String> actors) {
            this.actors = actors;
            return this.self();
        }

        public B participants(List<String> participants) {
            this.participants = participants;
            return this.self();
        }

        public B types(List<DocumentActivityActionTypesFilter> types) {
            this.types = types;
            return this.self();
        }

        public B stateNames(List<String> stateNames) {
            this.stateNames = stateNames;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "DocumentActivityQueryFilter.DocumentActivityQueryFilterBuilder(fromDate=" + this.fromDate + ", toDate=" + this.toDate + ", actors=" + this.actors + ", participants=" + this.participants + ", types=" + this.types + ", stateNames=" + this.stateNames + ")";
        }
    }
}

