/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.rest;

import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.confluence.workflowcontainer.model.RemoteWorkflowsRepository;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRepositoryRestModel
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RemoteRepositoryRestModel.class);
    public String status;
    public String date;
    public List<Workflow> workflows;

    private static Map<String, String> buildTransitionMapFromState(com.comalatech.confluence.states.model.State s) {
        HashMap<String, String> transitions = new HashMap<String, String>();
        if (s.getApprovedStateName() != null) {
            transitions.put("approved", s.getApprovedStateName());
        }
        if (s.getRejectedStateName() != null) {
            transitions.put("rejected", s.getRejectedStateName());
        }
        if (s.getUpdatedStateName() != null) {
            transitions.put("updated", s.getUpdatedStateName());
        }
        if (s.getCompletedStateName() != null) {
            transitions.put("completed", s.getCompletedStateName());
        }
        if (s.getExpiredStateName() != null) {
            transitions.put("expired", s.getExpiredStateName());
        }
        if (s.getSubmitState() != null) {
            transitions.put("submitted", s.getSubmitState().getName());
        }
        return transitions;
    }

    public static RemoteRepositoryRestModel buildFrom(WorkflowContainerManager workflowContainerManager, RemoteWorkflowsRepository remoteRepository) {
        RemoteRepositoryRestModel model = new RemoteRepositoryRestModel();
        model.status = remoteRepository.getStatus();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        model.date = dateFormat.format(remoteRepository.getDate());
        model.workflows = remoteRepository.stream().map(w -> {
            List<Category> categories = w.getCategories().stream().map(c -> new Category(c.getId(), c.getName(), c.getDescription())).collect(Collectors.toList());
            try {
                List<State> states = workflowContainerManager.renderWorkflow(w.getBody()).getStatesContainer().getStates().stream().map(s -> new State(s.getName(), s.getDescription(), s.getColour(), s.isHideFromPath(), RemoteRepositoryRestModel.buildTransitionMapFromState(s))).collect(Collectors.toList());
                return new Workflow(w.getId(), w.getName(), w.getDescription(), w.getBody(), w.getVersion(), w.getWorkflowUrl(), categories, states);
            }
            catch (WorkflowException ex) {
                log.error("Error fetching states", (Throwable)ex);
                return new Workflow(w.getId(), w.getName(), w.getDescription(), w.getBody(), w.getVersion(), w.getWorkflowUrl(), categories, null);
            }
        }).collect(Collectors.toList());
        return model;
    }

    public static class Category
    implements Serializable {
        public String id;
        public String name;
        public String description;

        public Category() {
        }

        public Category(String id, String name, String description) {
            this.id = id;
            this.name = name;
            this.description = description;
        }
    }

    public static class State
    implements Serializable {
        public String name;
        public String description;
        public String colour;
        public Boolean hideFromPath;
        public Map<String, String> transitions;

        public State() {
        }

        public State(String name, String description, String colour, Boolean hideFromPath, Map<String, String> transitions) {
            this.name = name;
            this.description = description;
            this.colour = colour;
            this.hideFromPath = hideFromPath;
            this.transitions = transitions;
        }
    }

    public static class Workflow
    implements Serializable {
        public String id;
        public String name;
        public String description;
        public String body;
        public int version;
        public String link;
        public List<Category> categories;
        public List<State> states;

        public Workflow() {
        }

        public Workflow(String id, String name, String description, String body, int version, String link, List<Category> categories, List<State> states) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.body = body;
            this.version = version;
            this.link = link;
            this.categories = categories;
            this.states = states;
        }
    }
}

