/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.compatibility;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.workflow.compatibility.AttachmentIdHelper57;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AttachmentIdHelper {
    private static final Logger log = LoggerFactory.getLogger(AttachmentIdHelper.class);
    protected static final String ATTACHMENT_OLD_ID_KEY = "OLD_ATTACHMENT_ID";
    protected final AttachmentManager attachmentManager;
    protected final PageManager pageManager;

    public AttachmentIdHelper(@ComponentImport AttachmentManager attachmentManager, @ComponentImport PageManager pageManager) {
        this.attachmentManager = attachmentManager;
        this.pageManager = pageManager;
    }

    public Map<Long, Long> getOldNewAttachmentIds(long pageId) {
        AbstractPage page = this.pageManager.getAbstractPage(pageId);
        List attachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page);
        HashMap<Long, Long> oldNewIdMap = new HashMap<Long, Long>();
        for (Attachment attachment : attachments) {
            long oldId = AttachmentIdHelper57.getAttachmentLongProperty(attachment, ATTACHMENT_OLD_ID_KEY);
            if (oldId <= 0L) continue;
            oldNewIdMap.put(oldId, attachment.getId());
        }
        if (log.isDebugEnabled()) {
            log.debug("page: " + page + "      attachment oldNewIdMap: " + oldNewIdMap);
        }
        return oldNewIdMap;
    }
}

