/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.model;

import com.comalatech.confluence.states.model.Activity;
import com.comalatech.workflow.model.Completion;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TaskCompletion
extends Activity
implements Completion {
    public static final String OUTCOME_APPROVE = "approve";
    public static final String OUTCOME_REJECT = "reject";
    private int approvalCheckId;
    private String outcome;

    public TaskCompletion() {
    }

    public TaskCompletion(String user, Date date) {
        super(user, date);
    }

    public TaskCompletion(String user, Date date, String outcome, String comment) {
        this(user, date);
        this.setComment(comment);
        this.setOutcome(outcome);
    }

    public int getApprovalCheckId() {
        return this.approvalCheckId;
    }

    public void setApprovalCheckId(int approvalCheckId) {
        this.approvalCheckId = approvalCheckId;
    }

    @Override
    public Map<String, String> getAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("approvalCheckId", Integer.toString(this.approvalCheckId));
        map.put("outcome", this.outcome);
        return map;
    }

    public boolean isApprove() {
        return OUTCOME_APPROVE.equals(this.outcome);
    }

    public boolean isReject() {
        return OUTCOME_REJECT.equals(this.outcome);
    }

    @Override
    public String getCssClass() {
        StringBuffer sb = new StringBuffer(super.getCssClass());
        if (this.isApprove()) {
            sb.append(" ").append(OUTCOME_APPROVE);
        }
        if (this.isReject()) {
            sb.append(" ").append(OUTCOME_REJECT);
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskCompletion that = (TaskCompletion)o;
        if (this.approvalCheckId != that.approvalCheckId) {
            return false;
        }
        return Objects.equals(this.outcome, that.outcome);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.approvalCheckId;
        result = 31 * result + (this.outcome != null ? this.outcome.hashCode() : 0);
        return result;
    }

    @Override
    public String getOutcome() {
        return this.outcome;
    }

    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    @Override
    public String toString() {
        return "completed " + Activity.toString(this);
    }

    @Override
    public String getActivityId() {
        return "0";
    }

    @Override
    public String getActivityKey() {
        return "completion";
    }
}

