/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.comalatech.confluence.ipc.ValueAccessor;
import com.comalatech.confluence.metadata.atlassian.AtlassianMetadataAccessor;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.stereotype.Component;

@Component
public class MetadataValueAccessor
implements ValueAccessor {
    private static final String METADATA_KEY_PREFIX = "metadata.";
    private static final String METADATA_KEYS = "metadatakeys";
    private final ComalaPropertiesSetManager contentPropertyManager;
    private final AtlassianMetadataAccessor atlassianMetadataAccessor;

    public MetadataValueAccessor(ComalaPropertiesSetManager contentPropertyManager, AtlassianMetadataAccessor atlassianMetadataAccessor) {
        this.contentPropertyManager = contentPropertyManager;
        this.atlassianMetadataAccessor = atlassianMetadataAccessor;
    }

    @Override
    public String getValue(AbstractPage page, String valueName, int loopIterations) {
        String name = valueName.trim();
        String key = METADATA_KEY_PREFIX + name;
        String value = this.contentPropertyManager.getTextProperty((ContentEntityObject)page.getLatestVersion(), key);
        if (value != null) {
            return value;
        }
        return this.getAtlassianMetadataValue(page, name, loopIterations);
    }

    private String getAtlassianMetadataValue(AbstractPage page, String valueName, int loopIterations) {
        String escapedValueName = StringEscapeUtils.escapeHtml4((String)valueName);
        return this.atlassianMetadataAccessor.getValue((ContentEntityObject)page, escapedValueName, loopIterations);
    }

    @Override
    public void setValue(AbstractPage page, String key, String value) {
        key = key.trim();
        this.contentPropertyManager.setTextProperty((ContentEntityObject)page, METADATA_KEY_PREFIX + key, value);
        this.addMetadataKey(page, key);
    }

    @Override
    public void removeValue(AbstractPage page, String key) {
        key = key.trim();
        this.contentPropertyManager.removeProperty((ContentEntityObject)page, METADATA_KEY_PREFIX + key);
        this.removeMetadataKey(page, key);
    }

    private void addMetadataKey(AbstractPage page, String key) {
        String keysList = this.contentPropertyManager.getTextProperty((ContentEntityObject)page, METADATA_KEYS);
        StringBuffer newList = new StringBuffer();
        String separator = "";
        if (keysList != null) {
            String[] keys;
            for (String key1 : keys = keysList.split("\\|")) {
                String existingKey = key1.trim();
                if (existingKey.equals(key)) {
                    return;
                }
                newList.append(separator).append(existingKey);
                separator = "|";
            }
        }
        newList.append(separator).append(key);
        this.contentPropertyManager.setTextProperty((ContentEntityObject)page, METADATA_KEYS, newList.toString());
    }

    private void removeMetadataKey(AbstractPage page, String key) {
        String keysList = this.contentPropertyManager.getTextProperty((ContentEntityObject)page, METADATA_KEYS);
        StringBuffer newList = new StringBuffer();
        String separator = "";
        if (keysList != null) {
            String[] keys;
            for (String key1 : keys = keysList.split("\\|")) {
                String existingKey = key1.trim();
                if (existingKey.equals(key)) continue;
                newList.append(separator).append(existingKey);
                separator = "|";
            }
        }
        this.contentPropertyManager.setTextProperty((ContentEntityObject)page, METADATA_KEYS, newList.toString());
    }
}

