/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageActivity;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.usecases.contracts.GenerateDocumentActivity;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.workflow.StateService;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GenerateActivityUseCase
implements GeneratePageActivity {
    private static final Logger log = LoggerFactory.getLogger(GenerateActivityUseCase.class);
    private final StateService stateService;
    private final GenerateDocumentActivity generateDocumentActivity;
    private final WorkflowAccessor workflowAccessor;

    public GenerateActivityUseCase(StateService stateService, GenerateDocumentActivity generateDocumentActivity, WorkflowAccessor workflowAccessor) {
        this.stateService = stateService;
        this.generateDocumentActivity = generateDocumentActivity;
        this.workflowAccessor = workflowAccessor;
    }

    @Override
    public LinkedHashMap<PageState, List<Activity>> generateCurrentStateActivities(AbstractPage page) throws Exception {
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        if (pageWorkflows == null) {
            log.debug("No workflow applied and active to the page {}", (Object)page.getIdAsString());
            return null;
        }
        PageState currentState = (PageState)this.stateService.getCurrentState((ContentEntityObject)page);
        if (currentState != null) {
            if (currentState.getPage() != null) {
                return this.generateDocumentActivity.generate(page, currentState);
            }
            log.error("Page" + page.getTitle() + " has not been state initialised");
        }
        log.debug("No activities generated for page {}", (Object)page.getTitle());
        return null;
    }
}

