/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.user.User;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.Migration;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.State;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GenerateCloudMappings;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageActivity;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageActivityMigrationData;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.jacksonMixins.MigrationStateMixin;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.states.model.PageState;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationDebugAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(MigrationDebugAction.class);
    private GenerateCloudMappings generateCloudMappings;
    private GeneratePageActivityMigrationData pageActivityGeneratorUseCase;
    private GeneratePageActivity generatePageActivity;
    private AdhocWorkflowsLicenseManager licenseManager;
    private PageManager pageManager;
    private String migrationStr;
    private String spaceKey;
    private Long pageId;

    public String execute() {
        String result;
        if (!this.licenseManager.isLicensed()) {
            this.migrationStr = "Invalid license";
            return "success";
        }
        try {
            Migration migration = null;
            ObjectMapper mapper = new ObjectMapper();
            if (this.pageId != null) {
                AbstractPage abstractPage = this.pageManager.getAbstractPage(this.pageId.longValue());
                if (abstractPage == null) {
                    this.migrationStr = "Page id does not exist";
                    return "success";
                }
                LinkedHashMap<PageState, List<Activity>> activities = this.generatePageActivity.generateCurrentStateActivities(abstractPage);
                migration = this.generateCloudMappings.generateMigrationDebugData(new HashMap<AbstractPage, LinkedHashMap<PageState, List<Activity>>>(Map.of(abstractPage, activities)));
            } else if (this.spaceKey != null) {
                List<String> spaceList = Collections.singletonList(this.spaceKey);
                HashMap<AbstractPage, LinkedHashMap<PageState, List<Activity>>> pageActivitiesMap = new HashMap<AbstractPage, LinkedHashMap<PageState, List<Activity>>>(this.pageActivityGeneratorUseCase.getActivities(spaceList));
                migration = this.generateCloudMappings.generateMigrationDebugData(pageActivitiesMap);
            }
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.addMixIn(State.class, MigrationStateMixin.class);
            result = mapper.writeValueAsString(migration);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.migrationStr = result;
        return "success";
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    @ParameterSafe
    public void setMigrationStr(String migrationStr) {
        this.migrationStr = migrationStr;
    }

    public void setGenerateCloudMappings(GenerateCloudMappings generateCloudMappings) {
        this.generateCloudMappings = generateCloudMappings;
    }

    public void setPageActivityGeneratorUseCase(GeneratePageActivityMigrationData pageActivityGeneratorUseCase) {
        this.pageActivityGeneratorUseCase = pageActivityGeneratorUseCase;
    }

    public void setLicenseManager(AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setGeneratePageActivity(GeneratePageActivity generatePageActivity) {
        this.generatePageActivity = generatePageActivity;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    @ParameterSafe
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    @ParameterSafe
    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public String getMigrationStr() {
        return this.migrationStr;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public Long getPageId() {
        return this.pageId;
    }
}

