/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.actions;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.user.User;
import com.atlassian.xwork.XsrfTokenGenerator;
import com.comalatech.confluence.cloud.migration.entity.domain.metadata.Metadata;
import com.comalatech.confluence.cloud.migration.service.DefaultCloudMigrationContentService;
import com.comalatech.confluence.cloud.migration.tasks.AttachActivityTask;
import com.comalatech.confluence.cloud.migration.tasks.AttachActivityTaskRecord;
import com.comalatech.confluence.cloud.migration.tasks.ExportMetadataRecord;
import com.comalatech.confluence.cloud.migration.tasks.ExportMetadataTask;
import com.comalatech.confluence.cloud.migration.tasks.MigrationTaskRecord;
import com.comalatech.confluence.cloud.migration.tasks.MigrationTaskStatus;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageMetadataMigrationData;
import com.comalatech.confluence.dataextractor.JsonContentPropertyService;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.util.ImpersonationUtil;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachActivityAction
extends AbstractSpaceAction
implements SpaceAware {
    private static final Logger log = LoggerFactory.getLogger(AttachActivityAction.class);
    private DefaultCloudMigrationContentService defaultCloudMigrationContentService;
    @ComponentImport
    private LongRunningTaskManager longRunningTaskManager;
    private AttachActivityTaskRecord recordPerPage;
    private AttachActivityTaskRecord recordPerSpace;
    private ExportMetadataRecord metadataRecord;
    @ComponentImport
    private XsrfTokenGenerator xsrfTokenGenerator;
    private ReadWriteTransactionService readWriteTransactionService;
    private ComalaI18nBean comalaI18nBean;
    @ComponentImport
    private GlobalSettingsManager globalSettingsManager;
    @ComponentImport
    private DarkFeatureManager darkFeatureManager;
    private GeneratePageMetadataMigrationData generatePageMetadataMigrationData;
    private JsonContentPropertyService jsonContentPropertyService;
    private ImpersonationUtil impersonationUtil;
    @ComponentImport
    private PageManager pageManager;
    @ComponentImport
    private ContentService contentService;
    private LongRunningTaskId taskId;

    public String view() {
        this.recordPerPage = this.defaultCloudMigrationContentService.getAttachActivityTaskStatus(this.getSpaceKey(), false);
        this.recordPerSpace = this.defaultCloudMigrationContentService.getAttachActivityTaskStatus(this.getSpaceKey(), true);
        this.metadataRecord = this.defaultCloudMigrationContentService.getExportMetadataTaskStatus(this.getSpaceKey());
        return "success";
    }

    @ReadOnlyAccessBlocked
    public String createAttachActivityPerPage() {
        this.recordPerPage = this.defaultCloudMigrationContentService.getAttachActivityTaskStatus(this.getSpaceKey(), false);
        if (this.recordPerPage == null) {
            this.recordPerPage = new AttachActivityTaskRecord();
            this.recordPerPage.setStatus(MigrationTaskStatus.NOT_RUN);
        }
        this.recordPerSpace = this.defaultCloudMigrationContentService.getAttachActivityTaskStatus(this.getSpaceKey(), true);
        if (this.recordPerSpace == null) {
            this.recordPerSpace = new AttachActivityTaskRecord();
            this.recordPerSpace.setStatus(MigrationTaskStatus.NOT_RUN);
        }
        if (!MigrationTaskStatus.IN_PROGRESS.equals((Object)this.recordPerPage.getStatus()) && !MigrationTaskStatus.IN_PROGRESS.equals((Object)this.recordPerSpace.getStatus())) {
            this.taskId = this.startTask(this.recordPerPage, false);
            this.recordPerPage.setLongRunningTaskId(this.taskId.toString());
        }
        return "success";
    }

    @ReadOnlyAccessBlocked
    public String createAttachActivityPerSpace() {
        if (this.space.getHomePage() == null) {
            log.error("There is no home page for space {}", (Object)this.getSpaceKey());
            return "error";
        }
        this.recordPerPage = this.defaultCloudMigrationContentService.getAttachActivityTaskStatus(this.getSpaceKey(), false);
        if (this.recordPerPage == null) {
            this.recordPerPage = new AttachActivityTaskRecord();
            this.recordPerPage.setStatus(MigrationTaskStatus.NOT_RUN);
        }
        this.recordPerSpace = this.defaultCloudMigrationContentService.getAttachActivityTaskStatus(this.getSpaceKey(), true);
        if (this.recordPerSpace == null) {
            this.recordPerSpace = new AttachActivityTaskRecord();
            this.recordPerSpace.setStatus(MigrationTaskStatus.NOT_RUN);
        }
        if (!MigrationTaskStatus.IN_PROGRESS.equals((Object)this.recordPerPage.getStatus()) && !MigrationTaskStatus.IN_PROGRESS.equals((Object)this.recordPerSpace.getStatus())) {
            this.taskId = this.startTask(this.recordPerSpace, true);
            this.recordPerSpace.setLongRunningTaskId(this.taskId.toString());
        }
        return "success";
    }

    @ReadOnlyAccessBlocked
    public String exportMetadata() {
        if (!this.darkFeatureManager.isEnabledForAllUsers("appfire.workflows.metadata.export").orElse(true).booleanValue()) {
            return "";
        }
        this.metadataRecord = this.defaultCloudMigrationContentService.getExportMetadataTaskStatus(this.getSpaceKey());
        if (this.metadataRecord == null) {
            this.metadataRecord = new ExportMetadataRecord();
            this.metadataRecord.setStatus(MigrationTaskStatus.NOT_RUN);
        }
        if (!MigrationTaskStatus.IN_PROGRESS.equals((Object)this.metadataRecord.getStatus())) {
            this.taskId = this.startTask(this.metadataRecord, true);
            this.metadataRecord.setLongRunningTaskId(this.taskId.toString());
        }
        return "success";
    }

    private LongRunningTaskId startTask(MigrationTaskRecord record, boolean isPerSpace) {
        LongRunningTaskId longRunningTaskId = null;
        if (record instanceof AttachActivityTaskRecord) {
            List<Long> pagesWithWorkflowIds = this.defaultCloudMigrationContentService.getPagesWithWorkflow(this.space.getId());
            AttachActivityTask attachCSVTask = new AttachActivityTask(this.getSpaceKey(), (AttachActivityTaskRecord)record, this.defaultCloudMigrationContentService, this.readWriteTransactionService, this.comalaI18nBean, pagesWithWorkflowIds, isPerSpace);
            longRunningTaskId = this.longRunningTaskManager.startLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), (LongRunningTask)attachCSVTask);
            log.debug("Space CSV attachment task did start, with long running task id {} for the space {}", (Object)longRunningTaskId, (Object)this.space.getKey());
        } else if (record instanceof ExportMetadataRecord) {
            List<Metadata> metadata = this.generatePageMetadataMigrationData.generatePageMetadata(this.getSpaceKey());
            if (metadata == null) {
                log.debug("Export Metadata task did not start, no metadata found for space {}", (Object)this.space.getKey());
            } else {
                LinkedHashMap groupByContent = metadata.stream().collect(Collectors.groupingBy(Metadata::getContentId, LinkedHashMap::new, Collectors.toList()));
                ExportMetadataTask exportMetadataTask = new ExportMetadataTask(this.getSpaceKey(), (ExportMetadataRecord)record, this.defaultCloudMigrationContentService, this.readWriteTransactionService, this.jsonContentPropertyService, this.contentService, this.comalaI18nBean, this.impersonationUtil, this.pageManager, groupByContent);
                longRunningTaskId = this.longRunningTaskManager.startLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), (LongRunningTask)exportMetadataTask);
                log.debug("Export Metadata task did start, with long running task id {} for the space {}", (Object)longRunningTaskId, (Object)this.space.getKey());
            }
        }
        return longRunningTaskId;
    }

    private boolean isConfluenceAdministrator() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public boolean isPermitted() {
        return super.isPermitted() && (this.isConfluenceAdministrator() || this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)this.space));
    }

    private String getTaskIdPerPage() {
        return this.recordPerPage.getLongRunningTaskId() != null ? this.recordPerPage.getLongRunningTaskId() : null;
    }

    private String getTaskIdPerSpace() {
        return this.recordPerSpace.getLongRunningTaskId() != null ? this.recordPerSpace.getLongRunningTaskId() : null;
    }

    private String getMetadataExportJobTaskId() {
        return this.metadataRecord.getLongRunningTaskId() != null ? this.metadataRecord.getLongRunningTaskId() : null;
    }

    public boolean getIsNotRunStatusPerPage() {
        return this.recordPerPage == null || MigrationTaskStatus.NOT_RUN.equals((Object)this.recordPerPage.getStatus());
    }

    public boolean getIsNotRunStatusPerSpace() {
        return this.recordPerSpace == null || MigrationTaskStatus.NOT_RUN.equals((Object)this.recordPerSpace.getStatus());
    }

    public boolean getIsInProgressStatusPerPage() {
        return this.recordPerPage != null && MigrationTaskStatus.IN_PROGRESS.equals((Object)this.recordPerPage.getStatus());
    }

    public boolean getIsInProgressStatusPerSpace() {
        return this.recordPerSpace != null && MigrationTaskStatus.IN_PROGRESS.equals((Object)this.recordPerSpace.getStatus());
    }

    public boolean getIsInFailStatusPerPage() {
        return this.recordPerPage != null && MigrationTaskStatus.FAIL.equals((Object)this.recordPerPage.getStatus());
    }

    public boolean getIsInFailStatusPerSpace() {
        return this.recordPerSpace != null && MigrationTaskStatus.FAIL.equals((Object)this.recordPerSpace.getStatus());
    }

    public boolean isMetadataJobNotRun() {
        return this.metadataRecord == null || MigrationTaskStatus.NOT_RUN.equals((Object)this.metadataRecord.getStatus());
    }

    public boolean isMetadataJobInProgress() {
        return this.metadataRecord != null && MigrationTaskStatus.IN_PROGRESS.equals((Object)this.metadataRecord.getStatus());
    }

    public boolean isMetadataJobFailed() {
        return this.metadataRecord != null && MigrationTaskStatus.FAIL.equals((Object)this.metadataRecord.getStatus());
    }

    public Date getStartDatePerPage() {
        if (this.recordPerPage == null || this.recordPerPage.getStartedTimestamp() == null) {
            return null;
        }
        return new Date(this.recordPerPage.getStartedTimestamp());
    }

    public Date getStartDatePerSpace() {
        if (this.recordPerSpace == null || this.recordPerSpace.getStartedTimestamp() == null) {
            return null;
        }
        return new Date(this.recordPerSpace.getStartedTimestamp());
    }

    public Date getMetadataExportJobStartDate() {
        if (this.metadataRecord == null || this.metadataRecord.getStartedTimestamp() == null) {
            return null;
        }
        return new Date(this.metadataRecord.getStartedTimestamp());
    }

    public String getDurationPerPage() {
        if (this.recordPerPage == null || this.recordPerPage.getStartedTimestamp() == null || this.recordPerPage.getEndedTimestamp() == null) {
            return null;
        }
        return "" + (this.recordPerPage.getEndedTimestamp() - this.recordPerPage.getStartedTimestamp()) / 1000L;
    }

    public String getDurationPerSpace() {
        if (this.recordPerSpace == null || this.recordPerSpace.getStartedTimestamp() == null || this.recordPerSpace.getEndedTimestamp() == null) {
            return null;
        }
        return "" + (this.recordPerSpace.getEndedTimestamp() - this.recordPerSpace.getStartedTimestamp()) / 1000L;
    }

    public String getMetadataExportJobDuration() {
        if (this.metadataRecord == null || this.metadataRecord.getStartedTimestamp() == null || this.metadataRecord.getEndedTimestamp() == null) {
            return null;
        }
        return "" + (this.metadataRecord.getEndedTimestamp() - this.metadataRecord.getStartedTimestamp()) / 1000L;
    }

    public String getJobLinkPerPage() {
        return this.globalSettingsManager.getGlobalSettings().getBaseUrl() + "/longrunningtask.action?taskId=" + this.getTaskIdPerPage() + "&atl_token=" + this.getAtlToken();
    }

    public String getJobLinkPerSpace() {
        return this.globalSettingsManager.getGlobalSettings().getBaseUrl() + "/longrunningtask.action?taskId=" + this.getTaskIdPerSpace() + "&atl_token=" + this.getAtlToken();
    }

    public String getMetadataExportJobLink() {
        return this.globalSettingsManager.getGlobalSettings().getBaseUrl() + "/longrunningtask.action?taskId=" + this.getMetadataExportJobTaskId() + "&atl_token=" + this.getAtlToken();
    }

    public boolean isMetadataExportJobDarkFeatureEnabled() {
        return this.darkFeatureManager.isEnabledForAllUsers("appfire.workflows.metadata.export").orElse(false);
    }

    private String getAtlToken() {
        return this.xsrfTokenGenerator.generateToken(ServletActionContext.getRequest());
    }

    public String getTaskId() {
        return this.taskId.toString();
    }

    public void setDefaultCloudMigrationContentService(DefaultCloudMigrationContentService defaultCloudMigrationContentService) {
        this.defaultCloudMigrationContentService = defaultCloudMigrationContentService;
    }

    public void setLongRunningTaskManager(LongRunningTaskManager longRunningTaskManager) {
        this.longRunningTaskManager = longRunningTaskManager;
    }

    public void setXsrfTokenGenerator(XsrfTokenGenerator xsrfTokenGenerator) {
        this.xsrfTokenGenerator = xsrfTokenGenerator;
    }

    public void setReadWriteTransactionService(ReadWriteTransactionService readWriteTransactionService) {
        this.readWriteTransactionService = readWriteTransactionService;
    }

    public void setComalaI18nBean(ComalaI18nBean comalaI18nBean) {
        this.comalaI18nBean = comalaI18nBean;
    }

    public void setGlobalSettingsManager(GlobalSettingsManager globalSettingsManager) {
        this.globalSettingsManager = globalSettingsManager;
    }

    public void setDarkFeatureManager(DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = darkFeatureManager;
    }

    public void setGeneratePageMetadataMigrationData(GeneratePageMetadataMigrationData generatePageMetadataMigrationData) {
        this.generatePageMetadataMigrationData = generatePageMetadataMigrationData;
    }

    public void setJsonContentPropertyService(JsonContentPropertyService jsonContentPropertyService) {
        this.jsonContentPropertyService = jsonContentPropertyService;
    }

    public void setImpersonationUtil(ImpersonationUtil impersonationUtil) {
        this.impersonationUtil = impersonationUtil;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }
}

