/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.api.model.search;

import com.atlassian.confluence.api.model.search.ContentSearchResult;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.util.GeneralUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchConf9Compatibility {
    private static final Logger log = LoggerFactory.getLogger(SearchConf9Compatibility.class);

    public static Date getLastModifiedAt(SearchResult searchResult) {
        OffsetDateTime lastModifiedAtOffset;
        if (GeneralUtil.getVersionNumber().startsWith(String.valueOf(9)) && (lastModifiedAtOffset = SearchConf9Compatibility._getLastModifiedAt(searchResult)) != null) {
            return Date.from(lastModifiedAtOffset.toInstant());
        }
        try {
            Class<?> dateTimeClass = SearchConf9Compatibility.getConfluenceDateTimeClass();
            Method getLastModifiedMethod = searchResult.getClass().getMethod("getLastModified", new Class[0]);
            Object lastModified = getLastModifiedMethod.invoke((Object)searchResult, new Object[0]);
            Object dateTimeInstance = dateTimeClass.cast(lastModified);
            Method toDateMethod = dateTimeClass.getMethod("toDate", new Class[0]);
            return (Date)toDateMethod.invoke(dateTimeInstance, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static OffsetDateTime _getLastModifiedAt(SearchResult searchResult) {
        try {
            Method queryMethod = ContentSearchResult.class.getMethod("getLastModifiedAt", new Class[0]);
            return (OffsetDateTime)queryMethod.invoke((Object)searchResult, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error("Error detected while retrieving lastModifiedAt through compatibility layer", (Throwable)e);
            return null;
        }
    }

    private static Class<?> getConfluenceDateTimeClass() throws ClassNotFoundException {
        ClassLoader confluenceClassLoader = SearchResult.class.getClassLoader();
        return Class.forName("org.joda.time.DateTime", true, confluenceClassLoader);
    }
}

