/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification.listener;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.comalatech.confluence.adhoc.notification.AdhocNotificationService;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.model.Notification;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.adhoc.notification.model.TaskNotification;
import com.comalatech.confluence.tasks.event.TaskCreateEvent;
import com.comalatech.confluence.util.FancyDateFormatter;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowsNotificationPublisher;
import com.comalatech.confluence.workflowcontainer.model.WorkflowVisibilityInternal;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.event.TaskAssignEvent;
import com.comalatech.workflow.event.TaskCompleteEvent;
import com.comalatech.workflow.event.TaskDueDateExpiredEvent;
import com.comalatech.workflow.event.TaskEvent;
import com.comalatech.workflow.model.Assignment;
import com.comalatech.workflow.model.Task;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;

@Component
public class TaskNotificationListener
extends WorkflowsListener {
    protected final WorkflowNotificationConfigManager workflowNotificationConfigManager;
    protected final AdhocNotificationService adhocNotificationService;
    protected final UserAccessor userAccessor;
    protected final NotificationManager notificationManager;
    protected final WorkflowAccessor workflowAccessor;
    protected final StateService stateService;
    protected final WorkflowConfigurationManager workflowConfigurationManager;
    protected final WorkflowsNotificationPublisher workflowsNotificationPublisher;

    public TaskNotificationListener(@ComponentImport EventPublisher eventPublisher, WorkflowNotificationConfigManager workflowNotificationConfigManager, AdhocNotificationService adhocNotificationService, @ComponentImport UserAccessor userAccessor, @ComponentImport NotificationManager notificationManager, WorkflowAccessor workflowAccessor, StateService stateService, WorkflowConfigurationManager workflowConfigurationManager, WorkflowsNotificationPublisher workflowsNotificationPublisher) {
        super(eventPublisher);
        this.workflowNotificationConfigManager = workflowNotificationConfigManager;
        this.adhocNotificationService = adhocNotificationService;
        this.userAccessor = userAccessor;
        this.notificationManager = notificationManager;
        this.workflowAccessor = workflowAccessor;
        this.stateService = stateService;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.workflowsNotificationPublisher = workflowsNotificationPublisher;
    }

    @EventListener
    public void taskCreate(TaskCreateEvent event) {
        AbstractPage page = (AbstractPage)event.getContent();
        Permission requiredPermission = this.getConfluencePermissionRequired(page);
        com.comalatech.confluence.states.model.Assignment assignment = event.getTask().getCurrentAssignment();
        ConfluenceUser modifier = AuthenticatedUserThreadLocal.get();
        ConfluenceUser assignee = null;
        HashSet<ConfluenceUser> assigneesSet = new HashSet<ConfluenceUser>();
        if (assignment != null) {
            if (StringUtils.isNotBlank((CharSequence)assignment.getAssignee())) {
                assignee = this.userAccessor.getUserByName(assignment.getAssignee());
            }
            if (assignee != null) {
                assigneesSet.add(assignee);
            }
            if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.TASK_ASSIGNMENT, page.getSpaceKey())) {
                TaskNotification notification = this.createTaskNotification(event.getTask(), page, "com.comalatech.task.notification.create.subject", assignment.getComment());
                notification.addContextProperty("assignee", assignee != null ? assignee.getFullName() : "");
                if (event.getTask().getDueDate() != null) {
                    notification.addContextProperty("activityDescription", "com.comalatech.task.notification.createAndAssignAndDueDate.assignee.description");
                    notification.addContextProperty("slackActivityDescription", "com.comalatech.task.notification.slack.createAndAssignAndDueDate.assignee.description");
                } else {
                    notification.addContextProperty("activityDescription", "com.comalatech.task.notification.createAndAssign.assignee.description");
                    notification.addContextProperty("slackActivityDescription", "com.comalatech.task.notification.slack.createAndAssign.assignee.description");
                }
                this.workflowsNotificationPublisher.publish(notification.getSubject(), notification.getBody(Notification.MessageSystem.SLACK), assigneesSet.stream().map(ConfluenceUser::getKey).map(UserKey::getStringValue).collect(Collectors.joining(",")), page);
                this.adhocNotificationService.sendEmail(notification, assigneesSet, requiredPermission);
            }
        }
        if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.TASK_PAGEWATCHER, page.getSpaceKey())) {
            Set<ConfluenceUser> watchers = this.adhocNotificationService.getContentWatchers(page, modifier, true, assigneesSet, null);
            String note = event.getTask().getComment();
            if (assignment != null) {
                note = assignment.getComment();
            }
            TaskNotification notification = this.createTaskNotification(event.getTask(), page, "com.comalatech.task.notification.create.subject", note);
            notification.addContextProperty("assignee", assignee != null ? assignee.getFullName() : "");
            if (assignment != null) {
                if (event.getTask().getDueDate() != null) {
                    notification.addContextProperty("activityDescription", "com.comalatech.task.notification.createAndAssignAndDueDate.watcher.description");
                    notification.addContextProperty("slackActivityDescription", "com.comalatech.task.notification.slack.createAndAssignAndDueDate.watcher.description");
                } else {
                    notification.addContextProperty("activityDescription", "com.comalatech.task.notification.createAndAssign.watcher.description");
                    notification.addContextProperty("slackActivityDescription", "com.comalatech.task.notification.slack.createAndAssign.watcher.description");
                }
            } else if (event.getTask().getDueDate() != null) {
                notification.addContextProperty("activityDescription", "com.comalatech.task.notification.createAndDueDate.watcher.description");
                notification.addContextProperty("slackActivityDescription", "com.comalatech.task.notification.slack.createAndDueDate.watcher.description");
            } else {
                notification.addContextProperty("activityDescription", "com.comalatech.task.notification.create.watcher.description");
                notification.addContextProperty("slackActivityDescription", "com.comalatech.task.notification.slack.create.watcher.description");
            }
            this.workflowsNotificationPublisher.publish(notification.getSubject(), notification.getBody(Notification.MessageSystem.SLACK), watchers.stream().map(ConfluenceUser::getKey).map(UserKey::getStringValue).collect(Collectors.joining(",")), page);
            this.adhocNotificationService.sendEmail(notification, watchers, requiredPermission);
        }
    }

    @EventListener
    public void taskAssigned(TaskAssignEvent event) {
        if (!event.isAtTaskCreation()) {
            AbstractPage page = (AbstractPage)event.getContent();
            Permission requiredPermission = this.getConfluencePermissionRequired(page);
            ConfluenceUser assignee = null;
            if (StringUtils.isNotBlank((CharSequence)event.getAssignment().getAssignee())) {
                assignee = this.userAccessor.getUserByName(event.getAssignment().getAssignee());
            }
            HashSet<ConfluenceUser> assigneesSet = new HashSet<ConfluenceUser>();
            if (assignee != null) {
                assigneesSet.add(assignee);
            }
            if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.TASK_ASSIGNMENT, page.getSpaceKey())) {
                TaskNotification notification = this.createTaskNotification(event.getTask(), page, "com.comalatech.task.notification.assigned.subject", event.getAssignment().getComment());
                notification.addContextProperty("assignee", assignee != null ? assignee.getFullName() : "");
                if (event.getTask().getDueDate() != null) {
                    notification.addContextProperty("activityDescription", "com.comalatech.task.notification.assignedAndDueDate.description");
                    notification.addContextProperty("slackActivityDescription", "com.comalatech.task.notification.slack.assignedAndDueDate.description");
                } else {
                    notification.addContextProperty("activityDescription", "com.comalatech.task.notification.assigned.description");
                    notification.addContextProperty("slackActivityDescription", "com.comalatech.task.notification.slack.assigned.description");
                }
                if (assignee != null) {
                    this.workflowsNotificationPublisher.publish(notification.getSubject(), notification.getBody(Notification.MessageSystem.SLACK), assignee.getKey().getStringValue(), page);
                }
                this.adhocNotificationService.sendEmail(notification, assigneesSet, requiredPermission);
            }
            if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.TASK_PAGEWATCHER, page.getSpaceKey())) {
                Assignment previousAssignment;
                ConfluenceUser modifier = AuthenticatedUserThreadLocal.get();
                List<? extends Assignment> previousAssignments = event.getTask().getAssignments();
                ConfluenceUser previousAssignee = null;
                if (previousAssignments != null && previousAssignments.size() > 1 && StringUtils.isNotBlank((CharSequence)(previousAssignment = previousAssignments.get(previousAssignments.size() - 2)).getAssignee())) {
                    previousAssignee = this.userAccessor.getUserByName(previousAssignment.getAssignee());
                }
                Set<ConfluenceUser> watchers = this.adhocNotificationService.getContentWatchers(page, modifier, true, assigneesSet, Collections.singleton(previousAssignee));
                TaskNotification notification = this.createTaskNotification(event.getTask(), page, "com.comalatech.task.notification.assigned.watcher.subject", event.getAssignment().getComment());
                notification.addContextProperty("assignee", assignee != null ? assignee.getFullName() : "");
                if (event.getTask().getDueDate() != null) {
                    notification.addContextProperty("activityDescription", "com.comalatech.task.notification.assignedAndDueDate.watcher.description");
                    notification.addContextProperty("slackActivityDescription", "com.comalatech.task.notification.slack.assignedAndDueDate.watcher.description");
                } else {
                    notification.addContextProperty("activityDescription", "com.comalatech.task.notification.assigned.watcher.description");
                    notification.addContextProperty("slackActivityDescription", "com.comalatech.task.notification.slack.assigned.watcher.description");
                }
                this.workflowsNotificationPublisher.publish(notification.getSubject(), notification.getBody(Notification.MessageSystem.SLACK), watchers.stream().map(ConfluenceUser::getKey).map(UserKey::getStringValue).collect(Collectors.joining(",")), page);
                this.adhocNotificationService.sendEmail(notification, watchers, requiredPermission);
            }
        }
    }

    @EventListener
    public void taskCompleted(TaskCompleteEvent event) {
        ConfluenceUser modifier = AuthenticatedUserThreadLocal.get();
        AbstractPage page = (AbstractPage)event.getContent();
        Permission requiredPermission = this.getConfluencePermissionRequired(page);
        TaskNotification notification = this.createTaskNotification(event.getTask(), page, "com.comalatech.task.notification.complete.watcher.subject", event.getCompletion().getComment());
        notification.addContextProperty("completer", modifier != null ? modifier.getFullName() : "");
        notification.addContextProperty("activityDescription", "com.comalatech.task.notification.complete.watcher.description");
        notification.addContextProperty("slackActivityDescription", "com.comalatech.task.notification.slack.complete.watcher.description");
        Set<ConfluenceUser> emailUsers = this.getEmailUserForCommonEventEmail(page, event, modifier);
        this.workflowsNotificationPublisher.publish(notification.getSubject(), notification.getBody(Notification.MessageSystem.SLACK), emailUsers.stream().map(ConfluenceUser::getKey).map(UserKey::getStringValue).collect(Collectors.joining(",")), page);
        this.adhocNotificationService.sendEmail(notification, emailUsers, requiredPermission);
    }

    @EventListener
    public void taskExpired(TaskDueDateExpiredEvent event) {
        AbstractPage page = (AbstractPage)event.getContent();
        Permission requiredPermission = this.getConfluencePermissionRequired(page);
        String message = event.getTask().getComment() != null ? event.getTask().getComment() : "";
        TaskNotification notification = this.createTaskNotification(event.getTask(), page, "com.comalatech.task.notification.expired.watcher.subject", message);
        notification.addContextProperty("activityDescription", "com.comalatech.task.notification.expired.watcher.description");
        notification.addContextProperty("slackActivityDescription", "com.comalatech.task.notification.slack.expired.watcher.description");
        Set<ConfluenceUser> emailUsers = this.getEmailUserForCommonEventEmail(page, event, null);
        this.workflowsNotificationPublisher.publish(notification.getSubject(), notification.getBody(Notification.MessageSystem.SLACK), emailUsers.stream().map(ConfluenceUser::getKey).map(UserKey::getStringValue).collect(Collectors.joining(",")), page);
        this.adhocNotificationService.sendEmail(notification, emailUsers, requiredPermission);
    }

    protected Set<ConfluenceUser> getEmailUserForCommonEventEmail(AbstractPage page, TaskEvent event, ConfluenceUser modifier) {
        Assignment assignment;
        HashSet<ConfluenceUser> emailUsers = new HashSet<ConfluenceUser>();
        if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.TASK_ASSIGNMENT, page.getSpaceKey()) && (assignment = event.getTask().getLastAssignment()) != null && StringUtils.isNotBlank((CharSequence)assignment.getAssignee())) {
            emailUsers.add(this.userAccessor.getUserByName(assignment.getAssignee()));
        }
        if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.TASK_PAGEWATCHER, page.getSpaceKey())) {
            emailUsers.addAll(this.adhocNotificationService.getContentWatchers(page, modifier, true, null, null));
        }
        return emailUsers;
    }

    protected TaskNotification createTaskNotification(Task task, AbstractPage page, String subjectI18n, String note) {
        TaskNotification notification = new TaskNotification(subjectI18n);
        notification.setEntityId(page.getId());
        notification.addContextProperty("taskName", task.getName());
        notification.addContextProperty("assignmentNoteHtml", StringUtils.isNotBlank((CharSequence)note) ? HtmlUtils.htmlEscape((String)note) : "");
        notification.addContextProperty("taskId", task.getActivityId());
        if (task.getDueDate() != null) {
            notification.addContextProperty("dueDate", FancyDateFormatter.decorateDateTimePretty(task.getDueDate(), false));
        }
        return notification;
    }

    protected Permission getConfluencePermissionRequired(AbstractPage page) {
        WorkflowVisibilityInternal visibility;
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        if (pageWorkflows != null && pageWorkflows.isRequiresFinalApproval() && !this.stateService.getCurrentState((ContentEntityObject)page).isPublished() && WorkflowVisibilityInternal.CONTRIBUTORS == (visibility = this.workflowConfigurationManager.getHistoryVisibility(page.getSpaceKey()))) {
            return Permission.EDIT;
        }
        return Permission.VIEW;
    }
}

