/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage.param;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.randombits.storage.BasedStorage;
import org.randombits.storage.ObjectBasedStorage;
import org.randombits.storage.param.Parameter;
import org.randombits.storage.param.ParameterStorage;

public class ObjectParameterStorage
extends ObjectBasedStorage
implements ParameterStorage<Object> {
    protected Map<String, Parameter<Object>> params = new HashMap<String, Parameter<Object>>();
    protected Set<String> names = new HashSet<String>();
    private Set<String> uNames = Collections.unmodifiableSet(this.names);

    public ObjectParameterStorage() {
        super(BasedStorage.BoxType.Virtual);
    }

    public void addAll(Collection<Parameter<Object>> params) {
        for (Parameter<Object> param : params) {
            this.add(param);
        }
    }

    @Override
    public void add(Parameter<Object> param) {
        this.checkReadOnly();
        this.params.put(param.getKey().toLowerCase(), param);
        this.names.add(param.getKey());
    }

    @Override
    protected Set<String> baseNameSet() {
        return this.uNames;
    }

    @Override
    protected Object getBaseObject(String name) {
        Parameter<Object> param = this.params.get(name.toLowerCase());
        return param == null ? null : param.getValue();
    }

    @Override
    protected void setBaseObject(String name, Object value) {
        Parameter<Object> param = this.params.get(name = name.toLowerCase());
        if (param == null) {
            this.add(new Parameter<Object>(name, value));
        } else {
            param.setValue(value);
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean getBoolean(int index, boolean def) {
        return this.getBoolean(String.valueOf(index), def);
    }

    @Override
    public Boolean getBoolean(int index, Boolean def) {
        return this.getBoolean(String.valueOf(index), def);
    }

    @Override
    public Date getDate(int index, Date def) {
        return this.getDate(String.valueOf(index), def);
    }

    @Override
    public DateTime getDateTime(int index, DateTime def) {
        return this.getDateTime(String.valueOf(index), def);
    }

    @Override
    public double getDouble(int index, double def) {
        return this.getDouble(String.valueOf(index), def);
    }

    @Override
    public Double getDouble(int index, Double def) {
        return this.getDouble(String.valueOf(index), def);
    }

    @Override
    public int getInteger(int index, int def) {
        return this.getInteger(String.valueOf(index), def);
    }

    @Override
    public Integer getInteger(int index, Integer def) {
        return this.getInteger(String.valueOf(index), def);
    }

    @Override
    public long getLong(int index, long def) {
        return this.getLong(String.valueOf(index), def);
    }

    @Override
    public Long getLong(int index, Long def) {
        return this.getLong(String.valueOf(index), def);
    }

    @Override
    public Object getObject(int index, Object def) {
        return this.getObject(String.valueOf(index), def);
    }

    @Override
    public List<?> getObjectList(int index, List<?> def) {
        return this.getObjectList(String.valueOf(index), def);
    }

    @Override
    public String getString(int index, String def) {
        return this.getString(String.valueOf(index), def);
    }

    @Override
    public String[] getStringArray(int index, String[] def) {
        return this.getStringArray(String.valueOf(index), def);
    }

    @Override
    public Set<String> getStringSet(int index, Set<String> def) {
        return this.getStringSet(String.valueOf(index), def);
    }
}

