/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.stats;

import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public enum StatsReportParameters {
    SPACE("space", "@self"),
    PARENT_PAGE("parent"),
    ANCESTOR_PAGE("ancestor"),
    LABEL("label"),
    STATE("state"),
    WORKFLOW("workflow");

    final String key;
    String defaultValue;

    private StatsReportParameters(String key) {
        this.key = key;
    }

    private StatsReportParameters(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public static Optional<StatsReportParameters> fromString(String text) {
        return Arrays.stream(StatsReportParameters.values()).filter(reportFilter -> reportFilter.key.equalsIgnoreCase(text)).findFirst();
    }

    public static List<ReportParameter> getFiltersFrom(Set<Map.Entry<?, ?>> macroParameterSet) {
        ArrayList<ReportParameter> statsReportFilters = new ArrayList<ReportParameter>();
        for (Map.Entry<?, ?> macroParam : macroParameterSet) {
            Optional<StatsReportParameters> filter = StatsReportParameters.fromString(macroParam.getKey().toString());
            if (!filter.isPresent()) continue;
            String value = macroParam.getValue() == null ? null : macroParam.getValue().toString().trim();
            statsReportFilters.add(new ReportParameter(filter.get().key, new StringReportParameterValue(value, filter.get().defaultValue)));
        }
        StatsReportParameters.addMandatoryParameters(statsReportFilters);
        return statsReportFilters;
    }

    private static void addMandatoryParameters(List<ReportParameter> statsReportFilters) {
        boolean existSpaceParam = statsReportFilters.stream().anyMatch(param -> param.getKey().equals(SPACE.getKey()));
        if (!existSpaceParam) {
            statsReportFilters.add(new ReportParameter(StatsReportParameters.SPACE.key, new StringReportParameterValue(null, StatsReportParameters.SPACE.defaultValue)));
        }
    }

    public String getKey() {
        return this.key;
    }
}

