/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.macros.actions.SendEmailMacro;
import com.comalatech.confluence.workflow.macros.templates.MacroParameters;
import com.comalatech.confluence.workflow.macros.templates.NoBodyBaseMacro;
import com.comalatech.confluence.workflowreports.ActivityManager;
import com.comalatech.confluence.workflowreports.ReportDateFormatter;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportOptions;
import com.opensymphony.xwork2.ActionContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageActivityMacro
extends NoBodyBaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(PageActivityMacro.class);
    private ActivityManager activityManager;
    private WorkflowConfigurationManager workflowConfigurationManager;
    private ReportDateFormatter dateFormatter;
    private WorkflowsFeatureManager workflowsFeatureManager;
    private ComalaI18nBean comalaI18nBean;
    private BootstrapManager bootstrapManager;
    private GlobalSettingsManager globalSettingsManager;
    private static final String DEFAULT_TEMPLATE = "templates/reports/activity/activity.vm";
    private static final String EMAIL_TEMPLATE = "templates/reports/activity/activityemail.vm";

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        try {
            if (context.getProperty("releaseview") != null) {
                parameters.put("releaseview", context.getPropertyAsString("releaseview"));
            }
            return this.execute(parameters, (RenderContext)context.getPageContext());
        }
        catch (MacroException e) {
            throw new MacroExecutionException((Throwable)e);
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    @Override
    public String execute(Map parameters, RenderContext renderContext) throws MacroException {
        ReportOptions options = new ReportOptions(parameters, renderContext);
        ActivityReportOptions reportOptions = options.getReportOptions();
        AbstractPage page = options.getAbstractPage();
        if (page == null) {
            return this.renderErrorMessage(this.comalaI18nBean.getText(this.workflowsFeatureManager.getPluginKey() + ".pageactivity.error.heading"), this.comalaI18nBean.getText(this.workflowsFeatureManager.getPluginKey() + ".pageactivity.error.params.noPage"));
        }
        List<ActivityReportEntry> report = this.activityManager.getActivityReport(options.getAbstractPage(), reportOptions);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("activityReportEntries", report);
        context.put("bootstrapManager", this.bootstrapManager);
        context.put("page", this.getAbstractPage(renderContext));
        context.put("options", reportOptions);
        context.put("pdf", options.pdf);
        context.put("hideDisplaySelector", true);
        context.put("reportDateFormatter", this.dateFormatter);
        context.put("workflowLogo", this.workflowConfigurationManager.getConfiguration().getWorkflowLogo());
        context.put("workflowAuthor", this.workflowConfigurationManager.getConfiguration().getWorkflowAuthor());
        context.put("baseUrl", this.globalSettingsManager.getGlobalSettings().getBaseUrl());
        return this.renderTemplate(context, options.template);
    }

    protected String renderErrorMessage(String header, String message) {
        return "<div class=\"aui-message aui-message-error\">\n    <p class=\"title\">\n        <strong>" + header + "</strong>\n    </p>\n    <p>" + StringEscapeUtils.escapeHtml4((String)message) + "</p>\n</div>\n";
    }

    public void setActivityManager(ActivityManager activityManager) {
        this.activityManager = activityManager;
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public void setLocaleManager(LocaleManager localeManager) {
        if (this.dateFormatter == null) {
            this.dateFormatter = new ReportDateFormatter(localeManager);
        }
    }

    public void setWorkflowsFeatureManager(WorkflowsFeatureManager workflowsFeatureManager) {
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    public void setComalaI18nBean(ComalaI18nBean comalaI18nBean) {
        this.comalaI18nBean = comalaI18nBean;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setGlobalSettingsManager(GlobalSettingsManager globalSettingsManager) {
        this.globalSettingsManager = globalSettingsManager;
    }

    public class ReportOptions
    extends MacroParameters {
        boolean ascending;
        boolean hideEdits;
        boolean hideComments;
        boolean hideStates;
        boolean hideTasks;
        boolean email;
        boolean pdf;
        String template;
        int maxEntries;
        boolean publishedView;
        boolean hideHeading;

        private ReportOptions(Map parameters, RenderContext renderContext) throws MacroException {
            super(parameters, renderContext);
            this.ascending = this.getFlag(new String[]{"ascending"});
            this.hideEdits = this.getFlag(new String[]{"hideedits", "hideEdits"});
            this.hideComments = this.getFlag(new String[]{"hidecomments", "hideComments"});
            this.hideStates = this.getFlag(new String[]{"hidestates", "hideStates"});
            this.hideTasks = this.getFlag(new String[]{"hidetasks", "hideTasks"});
            this.hideHeading = this.getFlag(new String[]{"hideheading", "hideHeading", "hideheader"});
            this.email = this.getFlag(new String[]{"email", "eMail"}) || SendEmailMacro.isEmailBody(renderContext);
            String outputType = renderContext.getOutputType();
            this.pdf = StringUtils.isNotBlank((CharSequence)outputType) ? outputType.equalsIgnoreCase("pdf") : false;
            this.template = this.email ? PageActivityMacro.EMAIL_TEMPLATE : PageActivityMacro.DEFAULT_TEMPLATE;
            int defaultMax = this.email ? 3 : Integer.MAX_VALUE;
            this.maxEntries = this.getInt(new String[]{"max", "maxentries", "entries", "maxEntries"}, defaultMax);
            this.publishedView = ActionContext.getContext() != null && ("releaseview".equals(ActionContext.getContext().getActionName()) || ActionContext.getContext().get("releaseview") != null || parameters.get("releaseview") != null);
        }

        public ActivityReportOptions getReportOptions() {
            ActivityReportOptions options = new ActivityReportOptions(this.ascending, this.hideEdits, this.hideComments, this.hideStates, this.hideTasks, this.hideHeading, this.maxEntries);
            options.setPublishView(this.publishedView);
            return options;
        }
    }
}

