/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.stateRepository;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.dao.ComalatechBandanaContext;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StatesContainer;
import com.comalatech.confluence.workflow.stateRepository.WorkflowStateRepository;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class WorkflowStateRepositoryImpl
implements WorkflowStateRepository {
    private static final String STATE_NAMES_KEY = "com.comalatech.workflow.state.names";
    private final BandanaManager bandanaManager;

    public WorkflowStateRepositoryImpl(@ComponentImport BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    @Override
    public void setInstanceStateNames(StatesContainer statesContainer) {
        this.setSpaceKeyStateNames(statesContainer, null);
    }

    @Override
    public void setSpaceKeyStateNames(StatesContainer statesContainer, String spaceKey) {
        ComalatechBandanaContext context = spaceKey == null ? ComalatechBandanaContext.COMALATECH_CONTEXT : new ConfluenceBandanaContext(spaceKey);
        Object stateNames = this.bandanaManager.getValue((BandanaContext)context, STATE_NAMES_KEY);
        if (stateNames == null) {
            this.bandanaManager.setValue((BandanaContext)context, STATE_NAMES_KEY, (Object)this.appendStateNames(statesContainer.getStates(), ""));
        } else {
            this.bandanaManager.setValue((BandanaContext)context, STATE_NAMES_KEY, (Object)this.appendStateNames(statesContainer.getStates(), stateNames.toString()));
        }
    }

    @Override
    public List<String> getStateNames(String spaceKey) {
        ComalatechBandanaContext context = spaceKey == null ? ComalatechBandanaContext.COMALATECH_CONTEXT : new ConfluenceBandanaContext(spaceKey);
        Object stateNames = this.bandanaManager.getValue((BandanaContext)context, STATE_NAMES_KEY);
        if (stateNames == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(stateNames.toString().split(",")).map(String::trim).collect(Collectors.toList());
    }

    @Override
    public void removeInstanceStateNames() {
        this.removeSpaceStateNames(null);
    }

    @Override
    public void removeSpaceStateNames(String spaceKey) {
        ComalatechBandanaContext context = spaceKey == null ? ComalatechBandanaContext.COMALATECH_CONTEXT : new ConfluenceBandanaContext(spaceKey);
        this.bandanaManager.removeValue((BandanaContext)context, STATE_NAMES_KEY);
    }

    private String appendStateNames(List<State> states, String bandanaString) {
        HashSet<String> names = new HashSet<String>();
        for (State state : states) {
            names.add(state.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)bandanaString)) {
            Set bandanaStateNames = Arrays.stream(bandanaString.split(",")).map(String::trim).collect(Collectors.toSet());
            names.addAll(bandanaStateNames);
        }
        return String.join((CharSequence)", ", names);
    }
}

