/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.include.imported;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.links.linktypes.AbstractPageLink;
import com.atlassian.confluence.links.linktypes.BlogPostLink;
import com.atlassian.confluence.links.linktypes.PageLink;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.ContentIncludeStack;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.ExcerptHelper;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkResolver;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.macros.include.imported.IncludeMacroUtils;
import com.comalatech.confluence.workflow.macros.include.imported.MacroPanel;
import com.comalatech.confluence.workflow.macros.include.imported.PageProviderAdvancedMacros;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcerptIncludeMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(ExcerptIncludeMacro.class);
    protected PageProviderAdvancedMacros pageProvider;
    protected PermissionManager permissionManager;
    protected ExcerptHelper excerptHelper;
    protected Renderer viewRenderer;
    protected LinkResolver linkResolver;
    protected I18NBeanFactory i18NBeanFactory;
    protected LocaleManager localeManager;

    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        log.debug("Beginning execute.");
        PageContext context = conversionContext.getPageContext();
        ContentEntityObject contentEntityObject = null;
        String linkTitle = "";
        com.atlassian.confluence.xhtml.api.Link linkObj = IncludeMacroUtils.getLink(conversionContext);
        if (linkObj == null) {
            String linkText = this.getLinkText(parameters);
            AbstractPageLink link = this.getAbstractPageLink(context, linkText);
            if (link == null) {
                return this.getI18nBean().getText("excerptinclude.error.cannot-link-to", (Object[])new String[]{StringEscapeUtils.escapeHtml4((String)linkText)});
            }
            contentEntityObject = link.getDestinationContent();
            linkTitle = link.getPageTitle();
        } else {
            contentEntityObject = this.pageProvider.resolve(linkObj, conversionContext);
            linkTitle = contentEntityObject.getTitle();
        }
        try {
            contentEntityObject = this.resolveCEO(contentEntityObject);
        }
        catch (MacroException ex) {
            return ex.getMessage();
        }
        String bodyContent = this.getBodyContent(contentEntityObject, linkTitle, context);
        if (Boolean.parseBoolean(parameters.get("nopanel"))) {
            return bodyContent;
        }
        return MacroPanel.wrap(GeneralUtil.unescapeEntities((String)linkTitle), bodyContent, parameters, (RenderContext)context);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getBodyContent(ContentEntityObject contentEntityObject, String linkTitle, PageContext context) {
        if (contentEntityObject == null || !this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)contentEntityObject)) {
            return this.getI18nBean().getText("excerptinclude.error.page-does-not-exists", (Object[])new String[]{StringEscapeUtils.escapeHtml4((String)linkTitle)});
        }
        if (ContentIncludeStack.contains((ContentEntityObject)contentEntityObject)) {
            I18NBean i18nBean = this.getI18nBean();
            String message = i18nBean.getText("excerptinclude.error.recursive.message");
            String contents = i18nBean.getText("excerptinclude.error.recursive.contents", (Object[])new String[]{HtmlUtil.htmlEncode((String)contentEntityObject.getTitle())});
            return RenderUtils.blockError((String)message, (String)contents);
        }
        try {
            ContentIncludeStack.push((ContentEntityObject)contentEntityObject);
            PageContext excerptContext = new PageContext(contentEntityObject, context);
            String excerpt = this.excerptHelper.getExcerpt(contentEntityObject);
            DefaultConversionContext excerptConversionContext = new DefaultConversionContext((RenderContext)excerptContext);
            String string = this.viewRenderer.render(excerpt, (ConversionContext)excerptConversionContext);
            return string;
        }
        finally {
            ContentIncludeStack.pop();
        }
    }

    protected String getLinkText(Map<String, String> parameters) {
        String linkText = parameters.get("0");
        if (StringUtils.isBlank((CharSequence)linkText) && StringUtils.isBlank((CharSequence)(linkText = parameters.get("pageTitle")))) {
            linkText = parameters.get("blogPost");
        }
        return StringUtils.defaultString((String)linkText).trim();
    }

    protected AbstractPageLink getAbstractPageLink(PageContext context, String linkText) {
        Link link = this.linkResolver.createLink((RenderContext)context, linkText);
        if (!(link instanceof PageLink) && !(link instanceof BlogPostLink)) {
            return null;
        }
        return (AbstractPageLink)link;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setExcerptHelper(ExcerptHelper excerptHelper) {
        this.excerptHelper = excerptHelper;
    }

    public void setViewRenderer(Renderer viewRenderer) {
        this.viewRenderer = viewRenderer;
    }

    public void setLinkResolver(LinkResolver linkResolver) {
        this.linkResolver = linkResolver;
    }

    public void setI18NBeanFactory(I18NBeanFactory i18NBeanFactory) {
        this.i18NBeanFactory = i18NBeanFactory;
    }

    public void setLocaleManager(LocaleManager localeManager) {
        this.localeManager = localeManager;
    }

    protected I18NBean getI18nBean() {
        return this.i18NBeanFactory.getI18NBean(TimerUtils.getLocale(this.localeManager));
    }

    public void setPageProvider(PageProviderAdvancedMacros pageProvider) {
        this.pageProvider = pageProvider;
    }

    protected ContentEntityObject resolveCEO(ContentEntityObject ceo) throws MacroException {
        return ceo;
    }
}

