/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.facade.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import com.sun.mirror.util.SourcePosition;
import java.util.Collection;
import java.util.Map;

public class FacadeAnnotationProcessor
implements AnnotationProcessor {
    private static final String CLASS_NAME = Class.class.getName();
    private AnnotationProcessorEnvironment environment;
    private TypeDeclaration facade;
    private TypeDeclaration arrayTypeParameter;
    private DeclarationVisitor declarationVisitor;
    private Messager messager;

    public FacadeAnnotationProcessor(AnnotationProcessorEnvironment env) {
        this.environment = env;
        this.messager = this.environment.getMessager();
        this.facade = this.environment.getTypeDeclaration("org.randombits.facade.Facadable");
        this.arrayTypeParameter = this.environment.getTypeDeclaration("org.randombits.facade.ArrayTypeParameter");
        this.declarationVisitor = new FacadedDeclarationsVisitor();
    }

    public void process() {
        Collection declarations = this.environment.getTypeDeclarations();
        DeclarationVisitor scanner = DeclarationVisitors.getSourceOrderDeclarationScanner((DeclarationVisitor)this.declarationVisitor, (DeclarationVisitor)DeclarationVisitors.NO_OP);
        for (TypeDeclaration declaration : declarations) {
            declaration.accept(scanner);
        }
    }

    private class FacadedDeclarationsVisitor
    extends SimpleDeclarationVisitor {
        private FacadedDeclarationsVisitor() {
        }

        public void visitMethodDeclaration(MethodDeclaration method) {
            Collection annotations = method.getAnnotationMirrors();
            for (AnnotationMirror annotation : annotations) {
                AnnotationTypeDeclaration annotationTypeDecl = annotation.getAnnotationType().getDeclaration();
                if (annotationTypeDecl.equals(FacadeAnnotationProcessor.this.facade)) {
                    this.checkTypeIsFacadable(method.getReturnType(), annotation.getPosition());
                    continue;
                }
                if (!annotationTypeDecl.equals(FacadeAnnotationProcessor.this.arrayTypeParameter)) continue;
                TypeVariable componentType = null;
                if (method.getReturnType() instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)method.getReturnType();
                    if (arrayType.getComponentType() instanceof TypeVariable) {
                        componentType = (TypeVariable)arrayType.getComponentType();
                    } else {
                        FacadeAnnotationProcessor.this.messager.printError(annotation.getPosition(), "@ArrayTypeParameter may only be applied on methods which return a generic array.");
                    }
                } else {
                    FacadeAnnotationProcessor.this.messager.printError(annotation.getPosition(), "@ArrayTypeParameter may only be applied on methods which return a generic array.");
                }
                Integer index = null;
                ParameterDeclaration[] params = method.getParameters().toArray(new ParameterDeclaration[0]);
                for (Map.Entry entry : annotation.getElementValues().entrySet()) {
                    AnnotationTypeElementDeclaration annotationMethod = (AnnotationTypeElementDeclaration)entry.getKey();
                    if (!"value".equals(annotationMethod.getSimpleName())) continue;
                    AnnotationValue annotationValue = (AnnotationValue)entry.getValue();
                    Integer value = (Integer)annotationValue.getValue();
                    if (value < 0) {
                        FacadeAnnotationProcessor.this.messager.printError(annotation.getPosition(), "Array type parameter index must be 0 or greater but was " + value + ".");
                        continue;
                    }
                    if (value >= params.length) {
                        FacadeAnnotationProcessor.this.messager.printError(annotation.getPosition(), "Array type parameter index must be less than " + params.length + " but was " + value + ".");
                        continue;
                    }
                    index = value;
                }
                if (componentType == null || index == null) continue;
                ParameterDeclaration param = params[index];
                TypeMirror paramType = param.getType();
                boolean valid = false;
                if (componentType.equals(paramType)) {
                    valid = true;
                } else if (paramType instanceof ArrayType) {
                    valid = componentType.equals(((ArrayType)paramType).getComponentType());
                } else if (paramType instanceof DeclaredType) {
                    DeclaredType declared = (DeclaredType)paramType;
                    if (CLASS_NAME.equals(declared.getDeclaration().getQualifiedName())) {
                        Collection types = declared.getActualTypeArguments();
                        boolean bl = valid = types.size() == 1 && componentType.equals(types.iterator().next());
                    }
                }
                if (valid) continue;
                FacadeAnnotationProcessor.this.messager.printError(param.getPosition(), "When specified by @ArrayTypeParameter the '" + param.getType() + " " + param.getSimpleName() + "' parameter must one of the following: " + componentType + ", Class<" + componentType + ">, or " + componentType + "[].");
            }
        }

        public void visitParameterDeclaration(ParameterDeclaration declaration) {
            Collection annotations = declaration.getAnnotationMirrors();
            for (AnnotationMirror annotation : annotations) {
                if (!annotation.getAnnotationType().getDeclaration().equals(FacadeAnnotationProcessor.this.facade)) continue;
                this.checkTypeIsFacadable(declaration.getType(), declaration.getPosition());
            }
        }

        private void checkTypeIsFacadable(TypeMirror type, SourcePosition position) {
            if (type.equals(FacadeAnnotationProcessor.this.environment.getTypeUtils().getVoidType())) {
                FacadeAnnotationProcessor.this.messager.printError(position, "Methods returning void cannot be marked as @Facadable");
            } else if (type instanceof PrimitiveType) {
                FacadeAnnotationProcessor.this.messager.printError(position, "Primitive types cannot be marked as @Facadable");
            }
        }
    }
}

